﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Net;
using System.IO;
using System.Text.RegularExpressions;
using Microsoft.WindowsAzure.StorageClient;
using Microsoft.WindowsAzure;
using System.Threading;
using Microsoft.WindowsAzure.ServiceRuntime;


namespace Aplikacja
{
    public partial class _Default : System.Web.UI.Page
    {
        CloudQueue inputqueue;
        CloudQueue outputqueue;
        CloudStorageAccount csa;
        protected void Page_Load(object sender, EventArgs e)
        {
            //utworzenie obiektu podstawowego CloudStorageAccount oraz referencji do kolejek
            csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageCredentials"));
            CloudQueueClient cqc = csa.CreateCloudQueueClient();
            inputqueue = cqc.GetQueueReference("inputqueue");
            outputqueue = cqc.GetQueueReference("outputqueue");
            updateList();
        }

        private void updateList()
        {
            //zerowanie listy
            lastBulletedList.Items.Clear();
            //tworzenie kontekstu pobrania rekordów
            var context = new PrzetworzoneMP3DataServiceContext(csa.TableEndpoint.ToString(), csa.Credentials);
            //zdefiniowanie zapytania i pobranie rekordow 
            IEnumerable<PrzetworzoneMP3> query = context.PrzetworzoneMP3Table;
            query = query.OrderByDescending(x => x.Timestamp);
            //uzupełnianie zawartości kontolki lastBulletedList o nowo pobrane rekordy
            foreach (PrzetworzoneMP3 p in query)
            {
                lastBulletedList.Items.Add(new ListItem(p.Nazwa, p.Link));
            }
        }

        protected void startButton_Click(object sender, EventArgs e)
        {
            try
            {
                //sprawdzenie czy pole wprowadzania URL nie jest puste
                if (!String.IsNullOrEmpty(UrlTextBox.Text))
                {
                    //wykorzystujemy metodę getVideoDownloadLink do wyodbrębnienia URL do filmu MP4
                    string videoDownloadLink = getVideoDownloadLink(UrlTextBox.Text);
                    //Odkodowanie z formatu Unicode
                    videoDownloadLink = Uri.UnescapeDataString(videoDownloadLink);
                    //tworzenie unikatowego identyfikatora dla nowo dodanego filmu
                    Guid guid = Guid.NewGuid();
                    //przygotowanie komunikatu zawierającego URL do filmu MP4 oraz GUID
                    CloudQueueMessage startMessage = new CloudQueueMessage(guid.ToString() + "|" + videoDownloadLink);
                    //wysłanie komunikatu do kolejki
                    inputqueue.AddMessage(startMessage);

                    //zmienna przerywająca pętlę
                    bool finished = false;
                    while (!finished)
                    {
                        //sprawdzenie komunikatu i ustawienie jego czasu niewidoczności
                        CloudQueueMessage finishedMessage = outputqueue.GetMessage(new TimeSpan(0, 0, 0, 0, 500));
                        if (finishedMessage != null)
                        {
                            //wyodrębnienie składowych komunikatu
                            string[] temp = finishedMessage.AsString.Split('|');
                            string finishedGuid = temp[0];
                            string link = temp[1];

                            //sprawdzenie czy to jest oczekiwany komunikat
                            if (finishedGuid.Equals(guid.ToString()))
                            {
                                //przygotowanie i wyświetlenie wyniki w  kontrolce HyperLink
                                mp3Link.Text = "Pobierz MP3";
                                mp3Link.NavigateUrl = link;     
                                //usunięcie komunikatu z kolejki (ważne!)
                                outputqueue.DeleteMessage(finishedMessage);
                                //przerwanie pętli
                                finished = true;
                                //odświeżanie listy ostatnio przetworzonych
                                updateList();
                            }
                        }
                        Thread.Sleep(1000);
                    }
                }
                else
                {
                    //wyświeta się gdy użytkownik nie wpisał nic do kontrolki TextBox
                    errorLabel.Text = "Wklej link do filmu!";
                }
            }
            catch (Exception ex)
            {
                errorLabel.Text = "Błąd: " + ex.Message;
            }
        }

        private string getVideoDownloadLink(string url)
        {
            //przygotowanie obiektu string na kod źródłowy strony filmu z serwisu YouTube
            string html = String.Empty;
            try
            {
                //Przygotowanie metody obsługi protokołu HTTP
                WebRequest request = WebRequest.Create(url);
                //pobranie odpowiedzi z serwera
                WebResponse response = request.GetResponse();
                //Zapisanie strumienia odpowiedzi do obiektu html
                Stream stream = response.GetResponseStream();
                StreamReader reader = new StreamReader(stream);
                html = reader.ReadToEnd();
                stream.Dispose();
                reader.Dispose();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }

            //Utworzenie wyrażenia regularnego wyodrębniającego URL do pliku MP4
            Regex regLink1 = new Regex("http%253A%252F%252F.*?videoplayback.*?(?=(%26quality%3Dmedium))");
            //Utworzenie wyrażenia regularnego wyodrębniającego nazwę filmu
            Regex regName = new Regex(@"(?<=<title>).*(?=- YouTube.*</title>)", RegexOptions.Singleline);
            // Wyszukiwanie ciągu zgodnego z wyrażeniem
            Match m1 = regLink1.Match(html);
            Match m2 = regName.Match(html);        
            if (m1.Success && m2.Success)
            {
                //zwracanie znalezionych ciągów w postaci URL
                return Uri.UnescapeDataString(m1.Value).Replace("\\", "") + "&title=" + m2.Value.Trim();

            }
            else
            {
                throw new Exception("Link niepoprawny");
            }
        }
    }
}
