﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MvcWebRole1.Models;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.StorageClient;
using System.Web.Security;

namespace MvcWebRole1.Controllers
{
    public class ZdjecieController : Controller
    {
        private ZdjecieDBContext db = new ZdjecieDBContext();

        public ActionResult Search(string searchString)
        {
            //pobranie wszystkich zdjęć

            var zdjecia = (IQueryable)null;
            //jeśli szukana nazwa nie jest pusta, to należy wybrać odpowiednie rekordy
            if (!String.IsNullOrEmpty(searchString))
            {
                zdjecia = db.ZbiorZdjec.Where(x => x.Tytul.Contains(searchString));
            }
            else
                zdjecia = db.ZbiorZdjec.AsQueryable();
            return View("Index", zdjecia);
        }


        public ActionResult MojeZdjecia()
        {
            //jeśli użytkownik jest niezalogowany, to będzie przekierowywany na stronę startową
            if (!Request.IsAuthenticated)
                return RedirectToAction("Index", "Home");
            //pobranie Id aktualnie zalogowanego użytkownika
            Guid user = (Guid)Membership.GetUser().ProviderUserKey;
            //wybranie zdjęć tylko zalogowanego użytkownika
            var context = db.ZbiorZdjec.Where(x => x.UserId.Equals(user));
            return View(context);
        }


        //
        // GET: /Zdjecie/

        public ViewResult Index()
        {
            return View(db.ZbiorZdjec.ToList());
        }

        //
        // GET: /ZdjeciaZdjecie/Details/5

        public ActionResult Details(int id = 0)
        {
            //znalezienie zdjęcia do usuwaniawyświetlenia 
            Zdjecie zdjecie = db.ZbiorZdjec.Find(id);
            //jeśli nie istnieje, zwróć błąd
            if (zdjecie == null)
                return HttpNotFound();
            return View(zdjecie);
        }

        //
        // GET: /ZdjeciaZdjecie/Create
        //akcja wyświetlająca formularz
        public ActionResult Create()
        {
            //jeśli użytkownik jest niezalogowany, to będzie przekierowywany na stronę startową
            if (!Request.IsAuthenticated)
                return RedirectToAction("Index", "Home");
            return View();
        }
        // 
        // POST: /ZdjeciaZdjecie/Create
        //akcja dodająca rekord i wysyłająca zdjęcie do Azure Blobs
        [HttpPost]
        public ActionResult Create(Zdjecie zdjecie, HttpPostedFileBase Link)
        {
            //jeśli użytkownik jest niezalogowany, to będzie przekierowywany na stronę startową
            if (!Request.IsAuthenticated)
                return RedirectToAction("Index", "Home");

            //jeśli dane z formularze są poprawne oraz został wybrany plik obrazka 
            if (ModelState.IsValid && Link != null)
            {
                //przygotowanie klienta obsługi Azure Blobs, poświadczenia przechowywane w pliku konfiguracyjnym
                CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageCredentials"));
                CloudBlobClient cbc = csa.CreateCloudBlobClient();
                //wybranie kontenera blobów
                CloudBlobContainer zdjeciaContainer = cbc.GetContainerReference("pictures");
                BlobContainerPermissions bcp = new BlobContainerPermissions();
                bcp.PublicAccess = BlobContainerPublicAccessType.Blob;
                //utworzenie kontenera z prawami publicznymi
                zdjeciaContainer.CreateIfNotExist();
                zdjeciaContainer.SetPermissions(bcp);
                //przygotowanie bloba
                CloudBlob cb = zdjeciaContainer.GetBlobReference(Guid.NewGuid().ToString() + ".jpg");
                cb.Properties.ContentType = "image/jpeg, image/png";
                //wysłanie bloba do Azure Storage
                cb.UploadFromStream(Link.InputStream);
                //pobranie odsyłacza do obrazka w Azure Blobs
                zdjecie.Link = cb.Uri.ToString();
                //wprowadzenie Id użytkownika
                zdjecie.UserId = (Guid)Membership.GetUser().ProviderUserKey;
                //dodanie zdjęcia do bazy
                db.ZbiorZdjec.Add(zdjecie);
                db.SaveChanges();
                //przekierowanie do listy zdjęć użytkownika
                return RedirectToAction("MojeZdjecia");
            }

            return View(zdjecie);
        }


        //
        // GET: /ZdjeciaZdjecie/Edit/5
        public ActionResult Edit(int id = 0)
        {
            //znalezienie zdjęcia do edycji
            Zdjecie zdjecie = db.ZbiorZdjec.Find(id);
            //jeśli nie istnieje, zwróć błąd
            if (zdjecie == null)
                return HttpNotFound();
            //jeśli użytkownik jest niezalogowany lub nieuprawionynieuprawniony, to będzie przekierowywany na stronę startową 
            if (!Request.IsAuthenticated || !zdjecie.UserId.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");
            return View(zdjecie);

        }

        //
        // POST: /ZdjeciaZdjecie/Edit/5
        [HttpPost]
        public ActionResult Edit(Zdjecie zdjecie, string oldLink, HttpPostedFileBase Link)
        {
            //znalezienie zdjęcia do edycji
            Zdjecie zdj = db.ZbiorZdjec.Find(zdjecie.ID);
            //jeśli nie istnieje, zwróć błąd
            if (zdj == null)
                return HttpNotFound();
            //jeśli użytkownik jest niezalogowany lub nieuprawionynieuprawniony, to będzie przekierowywany na stronę startową 
            if (!Request.IsAuthenticated || !zdj.UserId.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");

            //jeśli dane z formularze formularza poprawne
            if (ModelState.IsValid)
            {
                //jeżeli zmieniono plik obrazka, to należy zapisać nowy do Azure Blobs
                if (Link != null)
                {
                    //przygotowanie klienta obsługi Azure Blobs, poświadczenia przechowywane w pliku konfiguracyjnym
                    CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageCredentials"));
                    CloudBlobClient cbc = csa.CreateCloudBlobClient();
                    CloudBlobContainer zdjeciaContainer = cbc.GetContainerReference("pictures");
                    zdjeciaContainer.CreateIfNotExist();
                    //przygotowanie bloba
                    CloudBlob cb = zdjeciaContainer.GetBlobReference(Guid.NewGuid().ToString() + ".jpg");
                    cb.Properties.ContentType = "image/jpeg, image/png";
                    cb.UploadFromStream(Link.InputStream);
                    //pobranie odsyłacza zmienionego obrazka
                    zdjecie.Link = cb.Uri.ToString();
                    //znalezienie starego bloba do usunięcia
                    CloudBlob oldBlob = zdjeciaContainer.GetBlobReference(oldLink);
                    //usuwanie bloba
                    oldBlob.Delete();

                }
                //jeżeli nie zmieniono, to zapisanie poprzedniego odsyłacza
                else
                {
                    zdjecie.Link = oldLink;
                }

                //wprowadzenie Id użytkownika
                zdjecie.UserId = (Guid)Membership.GetUser().ProviderUserKey;
                //oznaczenie rekordu jako zmodyfikowanego, ważne dla EF
                db.Entry(zdj).CurrentValues.SetValues(zdjecie);
                //dodanie zdjęcia do bazy
                db.SaveChanges();
                //przekierowanie do listy zdjęć użytkownika
                return RedirectToAction("MojeZdjecia");
            }
            return View(zdjecie);

        }

        //
        // GET: /ZdjeciaZdjecie/Delete/5
        public ActionResult Delete(int id = 0)
        {
            //znalezienie zdjęcia do usuwania
            Zdjecie zdjecie = db.ZbiorZdjec.Find(id);
            //jeśli nie istnieje, zwróć błąd
            if (zdjecie == null)
                return HttpNotFound();
            //jeśli użytkownik jest niezalogowany lub nieuprawionynieuprawniony, to będzie przekierowywany na stronę startową 
            if (!Request.IsAuthenticated || !zdjecie.UserId.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");

            return View(zdjecie);

        }

        //
        // POST: /ZdjeciaZdjecie/Delete/5
        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id = 0)
        {
            //znalezienie zdjęcia do usuwania
            Zdjecie zdjecie = db.ZbiorZdjec.Find(id);
            //jeśli nie istnieje, zwróć błąd
            if (zdjecie == null)
                return HttpNotFound();
            //jeśli użytkownik jest niezalogowany lub nieuprawionynieuprawniony, to będzie przekierowywany na stronę startową 
            if (!Request.IsAuthenticated || !zdjecie.UserId.Equals(Membership.GetUser().ProviderUserKey))
                return RedirectToAction("Index", "Home");

            //przygotowanie klienta obsługi Azure Blobs, poświadczenia przechowywane w pliku konfiguracyjnym
            CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageCredentials"));
            CloudBlobClient cbc = csa.CreateCloudBlobClient();
            //znalezienie bloba
            CloudBlob cb = cbc.GetBlobReference(zdjecie.Link);
            //usuwanie bloba
            cb.Delete();
            //usunięcie zdjęcia z bazy
            db.ZbiorZdjec.Remove(zdjecie);
            db.SaveChanges();
            //przekierowanie do listy zdjęć użytkownika
            return RedirectToAction("MojeZdjecia");
        }


        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}