﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace PersonalInformationService.DataTransferObjects
{
    [DataContract(Name = "ExtendedPerson")]
    public class ExtendedPersonDto
    {
        [DataMember]
        public string Name;
        [DataMember]
        public GenderDto Gender;
        [DataMember]
        public List<HobbyDto> Hobbies;
        [DataMember]
        public byte[] Photo;

        public ExtendedPersonDto()
        {
            //required by serializers
            this.Photo = new byte[1];
            Hobbies = new List<HobbyDto>();
            new Random().NextBytes(this.Photo);
        }

        public ExtendedPersonDto(int photoSize)
        {
            this.Photo = new byte[photoSize];
            Hobbies = new List<HobbyDto>();
            new Random().NextBytes(this.Photo);
        }
    }
}
