﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.ServiceModel.Description;
using DemoServices.ServiceImplementations;

namespace DemoServicesHosts.IntroduceServiceForExtensions
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("SimpleIntroduceService for extensions Host starting");
            using (ServiceHost host = new ServiceHost(typeof(SimpleIntroduceService),
                new Uri("http://localhost:7000/DemoServices/SimpleIntroduceService")))
            {
                host.Open();
                foreach (ServiceEndpoint se in host.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }

                Console.WriteLine("SimpleIntroduceService Host started. Press enter to stop.");
                Console.ReadLine();
            }
        }
    }
}
