﻿using System;
using System.ServiceModel;
using DemoServices.ServiceImplementations;
using System.ServiceModel.Description;

namespace DemoServicesHosts.EchoForRouting
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("EchoForRouting Host starting");
            using (ServiceHost host = new ServiceHost(typeof(SimpleEchoService),
                new Uri("http://localhost:7000/DemoServices/SimpleEchoService")))
            {
                host.Open();
                foreach (ServiceEndpoint se in host.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }

                Console.WriteLine("EchoForRouting Host started. Press enter to stop.");
                Console.ReadLine();
            }
        }
    }
}
