﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PersonalInformationClients.ServiceReferenceClient.PersonalInformationServiceReference;

namespace PersonalInformationClients.ServiceReferenceClient
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Press [ENTER] to call PersonalInformationService");
            Console.ReadLine();

            using (PersonalInformationServiceClient client = new PersonalInformationServiceClient("BasicHttpBinding_IPersonalInformationService"))
            {
                var response = client.GetPersonalInformation(
                    new PersonalInformationRequest()
                    {
                        PersonId = 1
                    });

                Console.WriteLine("Received response");
                foreach (var person in response.Persons)
                {
                    Console.WriteLine("{0} : {1} {2}", person.Id, person.Name, person.Surname);
                }
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }
    }
}
