﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using PersonalInformationService.ServiceImplementations;
using System.ServiceModel.Description;
using System.ServiceModel.Discovery;

namespace PersonalInformationHosts.FirstHostForDiscovery
{
    class Program
    {
        static void Main(string[] args)
        {
            using (ServiceHost host = new ServiceHost(typeof(SimplePersonalInformationService)))
            {
                //AnnouncementEndpoint announcementEndpoint = new UdpAnnouncementEndpoint();
                //ServiceDiscoveryBehavior serviceDiscoveryBehavior = new ServiceDiscoveryBehavior();
                //serviceDiscoveryBehavior.AnnouncementEndpoints.Add(announcementEndpoint);
                //host.Description.Behaviors.Add(serviceDiscoveryBehavior);

                Console.WriteLine("FirstPersonalInformationService (discovery enabled) is starting");
                host.Open();
                foreach (ServiceEndpoint se in host.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }
                Console.WriteLine("FirstPersonalInformationService started");
                Console.WriteLine("Press enter to close");
                Console.ReadLine();
            }
        }
    }
}
