﻿using System;
using System.ServiceModel;
using DemoServices.ServiceImplementations;
using System.ServiceModel.Description;

namespace DemoServicesHosts.GreetingBackupForRouting
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("GreetingBackupForRouting Host starting");
            using (ServiceHost host = new ServiceHost(typeof(SimpleGreetingService),
                new Uri("http://localhost:7000/DemoServices/BackupGreetingService")))
            {
                host.Open();
                foreach (ServiceEndpoint se in host.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }

                Console.WriteLine("GreetingBackupForRouting Host started. Press enter to stop.");
                Console.ReadLine();
            }
        }
    }
}
