﻿using System;
using System.ServiceModel;
using PersonalInformationService.ServiceImplementations;
using System.ServiceModel.Description;
using PersonalInformationService.ServiceContracts;
using PersonalServiceExtensions;

namespace PersonalInformationHosts.SelfHost
{
    class Program
    {
        static void Main(string[] args)
        {
            //RunHost();
            RunHostWithCustombinding();
        }

        private static void RunHost()
        {
            Console.WriteLine("Press [ENTER] to start service...");
            using (ServiceHost host =
               new ServiceHost(typeof(SimplePersonalInformationService)))
            {
                Console.WriteLine("Personal Information Service host starting");
                host.Open();
                Console.WriteLine("Press [ENTER] to stop service...");
                Console.ReadLine();
            }
        }

        private static void RunHostWithCustombinding()
        {
            Console.WriteLine("Press [ENTER] to start service...");
            using (ServiceHost host =
               new ServiceHost(typeof(SimplePersonalInformationService)))
            {
                host.AddServiceEndpoint(typeof(IPersonalInformationService), new CustomBinding(), new System.Uri("http://localhost:9000/PersonalInformationService/custom"));
                foreach (var endPoint in host.Description.Endpoints)
                {
                    Console.WriteLine(endPoint.Address);
                }
                Console.WriteLine("Personal Information Service host starting");
                host.Open();
                Console.WriteLine("Press [ENTER] to stop service...");
                Console.ReadLine();
            }
        }
    }
}