﻿using System.Collections.Generic;
using PersonalInformationService.Messages;
using PersonalInformationService.ServiceContracts;
using PersonalInformationService.DataTransferObjects;
using System;
using System.ServiceModel;

namespace PersonalInformationService.ServiceImplementations
{
    public class SimplePersonalInformationService : IPersonalInformationService
    {
        public PersonalInformationResponse GetPersonalInformation(PersonalInformationRequest request)
        {
            PrintReceivedMessage();
            return ProcessRequest(request);
            //return ProcessRequestFor15Seconds(request);
        }

        private void PrintReceivedMessage()
        {
            Console.WriteLine(System.ServiceModel.OperationContext.Current.RequestContext.RequestMessage);
        }

        private PersonalInformationResponse ProcessRequest(PersonalInformationRequest request)
        {
            PersonalInformationResponse response = new PersonalInformationResponse();
            response.Persons = new List<DataTransferObjects.PersonDto>();
            response.Persons.Add(new DataTransferObjects.PersonDto()
            {
                Id = request.PersonId,
                Name = "Maciej",
                Surname = "Grabek",
                Gender = GenderDto.Male
            });
            return response;
        }


        private PersonalInformationResponse ProcessRequestFor15Seconds(PersonalInformationRequest request)
        {
            PersonalInformationResponse response = new PersonalInformationResponse();
            response.Persons = new List<DataTransferObjects.PersonDto>();
            response.Persons.Add(new DataTransferObjects.PersonDto()
            {
                Id = request.PersonId,
                Name = "Maciej",
                Surname = "Grabek",
                Gender = GenderDto.Male
            });

            System.Threading.Thread.Sleep(TimeSpan.FromSeconds(15));
            return response;
        }
    }
}