﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using ODataBasedSilverlightApplication.AdventureWorksServiceReference;
using System.Data.Services.Client;

namespace ODataBasedSilverlightApplication
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(MainPage_Loaded);
        }

        void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            AdventureWorksEntities context = new AdventureWorksEntities(
                new Uri("http://localhost:4660/Services/AdventureWorksDataService.svc"));

            var categories = from c in context.ProductCategory
                             orderby c.Name
                             select c;
            //var categories = from c in context.ProductCategory
            //                 where c.Name.StartsWith("C")
            //                 orderby c.Name
            //                 select c;
            var collection = new DataServiceCollection<ProductCategory>();
            collection.LoadAsync(categories);
            collection.LoadCompleted += new EventHandler<LoadCompletedEventArgs>(collection_LoadCompleted);
            this.dataGrid1.DataContext = collection;
        }

        void collection_LoadCompleted(object sender, LoadCompletedEventArgs e)
        {
            if (e.Cancelled || e.Error != null)
            {
                MessageBox.Show("Something goes wrong");
            }
        }
    }
}
