﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DemoServices.ServiceContracts;
using System.ServiceModel;

namespace DemoServicesClients.ClientForRouting
{
    class Program
    {
        static void Main(string[] args)
        {
            //CallEcho();
            //CallBridge();
            //CallBackup();
            //CallBroadcast();
            CallExtensions();
        }

        private static void CallEcho()
        {
            //Uri baseAddr = new Uri("http://localhost:7000/DemoServices/SimpleEchoService");
            Uri baseAddr = new Uri("http://localhost:7000/DemoServices/SampleRoutingService");
            string message = "Routing demo message";

            Console.WriteLine("Press [ENTER] to call SimpleEchoService");
            Console.ReadLine();

            using (ChannelFactory<IEchoService> factory =
                new ChannelFactory<IEchoService>(new BasicHttpBinding(), new EndpointAddress(baseAddr)))
            {
                try
                {
                    IEchoService proxy = factory.CreateChannel();
                    Console.WriteLine("Service Response");
                    Console.WriteLine(proxy.GetData(message));
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Exception");
                    Console.WriteLine(ex.ToString());
                }
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

        private static void CallBridge()
        {
            //Uri baseAddr = new Uri("net.tcp://localhost:7001/DemoServices/ReverseService");
            Uri baseAddr = new Uri("http://localhost:7000/DemoServices/SampleRoutingService");
            string message = "Bridge demo message";

            Console.WriteLine("Press [ENTER] to call ReverseService");
            Console.ReadLine();

            using (ChannelFactory<IReverseService> factory =
                new ChannelFactory<IReverseService>(new BasicHttpBinding(), new EndpointAddress(baseAddr)))
            {
                try
                {
                    IReverseService proxy = factory.CreateChannel();
                    Console.WriteLine("Service Response");
                    Console.WriteLine(proxy.Reverse(message));
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Exception");
                    Console.WriteLine(ex.ToString());
                }
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

        private static void CallBackup()
        {
            //Uri baseAddr = new Uri("http://localhost:7000/DemoServices/SimpleGreetingService");
            Uri baseAddr = new Uri("http://localhost:7000/DemoServices/SampleRoutingService");

            Console.WriteLine("Press [ENTER] to call GreetingService");
            Console.ReadLine();

            using (ChannelFactory<IGreetingService> factory =
                new ChannelFactory<IGreetingService>(new BasicHttpBinding(), new EndpointAddress(baseAddr)))
            {
                try
                {
                    IGreetingService proxy = factory.CreateChannel();
                    Console.WriteLine("Service Response");
                    Console.WriteLine(proxy.SayHello(
                        new DemoServices.Messages.GreetingRequest() { Name = "Maciej Grabek" }).Message);

                }
                catch (Exception ex)
                {
                    Console.WriteLine("Exception");
                    Console.WriteLine(ex.ToString());
                }
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

        private static void CallBroadcast()
        {
            Console.WriteLine("Press [ENTER] to call BroadcastService");
            Console.ReadLine();

            Uri broadcastAddr = new Uri("http://localhost:7000/DemoServices/SampleBroadcastRoutingService");
            string message = "Sample broadcast message";

            using (ChannelFactory<IBroadcastDemoService> factory =
                new ChannelFactory<IBroadcastDemoService>(new BasicHttpBinding(), new EndpointAddress(broadcastAddr)))
            {
                try
                {
                    IBroadcastDemoService proxy = factory.CreateChannel();
                    proxy.ProcessData(message);
                    Console.WriteLine("Message sent");
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Exception");
                    Console.WriteLine(ex.ToString());
                }
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

        private static void CallExtensions()
        {
            //Uri baseAddr = new Uri("http://localhost:7000/DemoServices/SimpleIntroduceService");
            Uri baseAddr = new Uri("http://localhost:7000/DemoServices/SampleRoutingService");

            Console.WriteLine("Press [ENTER] to call SimpleIntroduceService");
            Console.ReadLine();

            using (ChannelFactory<IIntroduceService> factory =
                new ChannelFactory<IIntroduceService>(new BasicHttpBinding(), new EndpointAddress(baseAddr)))
            {
                try
                {
                    IIntroduceService proxy = factory.CreateChannel();
                    Console.WriteLine("Service Response");
                    Console.WriteLine(proxy.GetAddress());
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Exception");
                    Console.WriteLine(ex.ToString());
                }
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

    }
}
