﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using RIAPoweredSilverlightApplication.Web.Services;
using RIAPoweredSilverlightApplication.Web.Model;
using System.ServiceModel.DomainServices.Client;

namespace RIAPoweredSilverlightApplication
{
    public partial class MainPage : UserControl
    {
        AdventureWorksDomainContext _context = new AdventureWorksDomainContext();

        public MainPage()
        {
            InitializeComponent();
            LoadDataFromContext();
        }

        #region loading data
        private void LoadDataFromContext()
        {
            AdventureWorksDomainContext context = new AdventureWorksDomainContext();
            context.Load<ProductCategory>(context.GetProductCategoryQuery());
            this.dataGrid1.DataContext = context.ProductCategories;

            //context.Load<ProductCategory>(context.GetProductCategoryQuery(), ProductCategoryLoadedCallback, null);

            //productCategoryDomainDataSource.SubmitChanges();
            //context.SubmitChanges();
        }

        void ProductCategoryLoadedCallback(LoadOperation<ProductCategory> loadOperation)
        {
            if (!loadOperation.HasError)
            {
                this.dataGrid1.DataContext = loadOperation.Entities;
            }
        } 
        #endregion

        #region Change data
        private void btnChangeData_Click(object sender, RoutedEventArgs e)
        {
            _context.Load<ProductCategory>(_context.GetProductCategoryQuery(), ProductCategoryForModificationLoadedCallback, null);
        }

        void ProductCategoryForModificationLoadedCallback(LoadOperation<ProductCategory> loadOperation)
        {
            if (!loadOperation.HasError && this._context.ProductCategories.CanEdit)
            {
                var category = this._context.ProductCategories.FirstOrDefault();
                //category.Name = "Bikes";
                
                //to cause validation error
                category.Name += "mod";
                this._context.SubmitChanges(OnSubmitCompleted, null);
            }
        }

        private void OnSubmitCompleted(SubmitOperation so)
        {
            if (!so.HasError)
            {
                MessageBox.Show("Product Category saved");
            }
            else
            {
                MessageBox.Show(so.Error.Message);
                so.MarkErrorAsHandled();
            }
        } 
        #endregion

        

        private void productCategoryDomainDataSource_LoadedData(object sender, System.Windows.Controls.LoadedDataEventArgs e)
        {
            if (e.HasError)
            {
                System.Windows.MessageBox.Show(e.Error.ToString(), "Load Error", System.Windows.MessageBoxButton.OK);
                e.MarkErrorAsHandled();
            }
        }
    }
}
