﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using DemoServices.ServiceImplementations;
using System.ServiceModel.Description;

namespace DemoServicesHosts.GreetingForRouting
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("GreetingForRouting Host starting");
            using (ServiceHost host = new ServiceHost(typeof(SimpleGreetingService),
                new Uri("http://localhost:7000/DemoServices/SimpleGreetingService")))
            {
                host.Open();
                foreach (ServiceEndpoint se in host.Description.Endpoints)
                {
                    Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                }

                Console.WriteLine("GreetingForRouting Host started. Press enter to stop.");
                Console.ReadLine();
            }
        }
    }
}
