module.exports = {
  'default e2e tests': (browser) => {
    // otwórz przeglądarkę i sprawdź, czy element #app jest na stronie
    browser.url('http://localhost:8080')
      .waitForElementVisible('#app', 5000);
    // upewnij się, że ikona .toggle-volume nie jest widoczna
    browser.expect.element('.toggle-volume')
      .to.not.be.visible
    // sprawdź, czy przycisk pauzy jest nieaktywny
    browser.expect.element('[title=pause]')
      .to.have.attribute('disabled')
    // sprawdź, czy przycisk stopu jest nieaktywny
    browser.expect.element('[title=stop]')
      .to.have.attribute('disabled')
    // sprawdź, czy przycisk start jest aktywny.
    browser.expect.element('[title=start]')
      .to.not.have.attribute('disabled')
    // kliknij przycisk start i sprawdź, czy przycisk do przełączania dźwięku jest widoczny
    browser.click('[title=start]')
      .waitForElementVisible('.toggle-volume', 5000)
    // sprawdź, czy przycisk pauzy jest aktywny
    browser.expect.element('[title=pause]')
      .to.not.have.attribute('disabled')
    //sprawdź, czy przycisk stopu jest aktywny
    browser.expect.element('[title=stop]')
      .to.not.have.attribute('disabled')
    // sprawdź, czy przycisk stopu jest nieaktywny
    browser.expect.element('[title=start]')
      .to.have.attribute('disabled')
    browser.end()
  },
  'test oczekiwania na kota': (browser) => {
    browser.url('http://localhost:8080')
      .waitForElementVisible('#app', 5000)
    // początkowo element z kotem nie jest widoczny
    browser.expect.element('.well.kittens')
      .to.not.be.visible
    // kliknij przycisk startu i poczekaj na 7 sekund na pojawienie się elementu z kotem
    browser.click('[title=start]')
      .waitForElementVisible('.well.kittens', 7000)
    // sprawdź, czy obraz atrybut src pasujący do ciągu thecatapi
    browser.expect.element('.well.kittens img')
      .to.have.attribute('src')
      .which.matches(/thecatapi/);
    browser.end()
  }
}
