/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

/*jshint evil:true, multistr:true*/

var tests = require('./../type-syntax-test');
var jstransform = require('../../../src/jstransform');
var visitors = require('../../type-syntax').visitorList;
var fs = require('fs');

var out = '/**\n\
 * WARNING: This file is autogenerated by\n\
 * src/visitors/flow/__tests__/gen/generate-type-syntax-test.js\n\
 * Do NOT modify this file directly! Instead, add your tests to\n\
 * src/visitors/flow/__tests__/type-syntax-test.js and run\n\
 * src/visitors/flow/__tests__/gen/generate-type-syntax-test.js\n\
 */\n\n';

var data = {};
Object.keys(tests).forEach(function(sectionName) {
  var section = tests[sectionName];
  var sectionData = {};
  section.forEach(function(testCode) {
    var code;
    sectionData[testCode] = {};
    var testData = {};
    try {
      code = jstransform.transform(visitors, testCode).code;
      testData.raworiginal = testCode;
      testData.transformed = code;
      try {
        eval(code);
        testData.eval = 'No error';
      } catch (e) {
        testData.eval = e.message;
      }

    } catch (e) {
      testData.error = e.message;
    }
    sectionData[testCode] = testData;
  });
  data[sectionName] = sectionData;
});

out += 'module.exports = ' + JSON.stringify(data, null, 2) + ';\n';

fs.writeFileSync(__dirname + '/type-syntax-test.rec.js', out);
console.log('Recorded type-syntax-test.js output into type-syntax-test.rec.js');

