

# math-expression-evaluator
An extremely efficient, flexible and amazing evaluator for Math expression in Javascript.([Documentation](http://redhivesoftware.github.io/math-expression-evaluator/))

## Use cases
|Input|Result|Explanation|
|:---:|:---:| --- |
|**2+3-1**|4| Addition and Subtraction operator |
|**2\*5/10**|1| Multiplication and Division operator |
|**tan45** *or* **tan(45)**|1| Trigonometric Function ( tan in Degree mode) |
|**tan45** *or* **tan(45)**|1.619775190543862| Trigonometric Function ( tan in Radian mode) |
|**Pi1,15,n** *or* **Pi(1,15,n)**|1307674368000| Product of Sequence |
|**Sigma1,15,n** *or* **Sigma(1,15,n)**|120| Sum of Sequence( also called summation)  |
|**2^3**|8| Exponent( note this operator is left associative like MS Office) |
|**5P3**|60| Permutaion Method to calculate all the permutaions |
|**sincostan90** *or* **sin(cos(tan(90)))**|0.017261434031253| Multiple functions with or without parenthesis (both works) |

### [Fiddle Yourself](http://jsbin.com/fuyowu/1/edit?html,output)

## Installation
### Node JS
 **Using npm** 

    npm install math-expression-evaluator

### Browser
 **Using bower**

    bower install math-expression-evaluator

### How to run test

    npm test

## Supported symbols

|Symbol|Explanation|
|:---:|:---:|
|**+**| Addition Operator eg. 2+3 results 5 |
|**-**| Subtraction Operator eg. 2-3 results -1 |
|**/**| Division operator eg 3/2 results 1.5 |
|**\***| Multiplication Operator eg. 2\*3 results 6 |
|**Mod**| Modulus Operator eg. 3 Mod 2 results 1 |
|**(**| Opening Parenthesis |
|**)**| Closing Parenthesis |
|**Sigma**| Summation eg. Sigma(1,100,n) results 5050 |
|**Pi**| Product eg. Pi(1,10,n) results 3628800 |
|**n**| Variable for Summation or Product |
|**pi**| Math constant pi returns 3.14 |
|**e**| Math constant e returns 2.71 |
|**C**| Combination operator eg. 4C2 returns 6 |
|**P**| Permutation operator eg. 4P2 returns 12 |
|**!**| factorial operator eg. 4! returns 24 |
|**log**| logarithmic function with base 10 eg. log 1000 returns 3 |
|**ln**| natural log function with base e eg. ln 2 returns .3010 |
|**pow**| power function with two operator pow(2,3) returns 8 |
|**^**| power operator eg. 2^3 returns 8 |
|**root**| underroot function root 4 returns 2 | 
|**sin**| Sine function |
|**cos**| Cosine function |
|**tan**| Tangent function |
|**asin**| Inverse Sine funtion |
|**acos**| Inverse Cosine funtion |
|**atan**| Inverse Tangent funtion |
|**sinh**| Hyperbolic Sine funtion |
|**cosh**| Hyperbolic Cosine funtion |
|**tanh**| Hyperbolic Tangent funtion |
|**asinh**| Inverse Hyperbolic Sine funtion |
|**acosh**| Inverse Hyperbolic Cosine funtion |
|**atanh**| Inverse Hyperbolic Tangent funtion |

## Features  

### Amazing support for Sigma and Pi  
This is a fantastic feature of this calculator that it is capable of evaluating expressions containing **Sigma and Pi**.  
Passing `Sigma(1,100,n)` will evaluate to 5050 as n is summationed from 1 to 100.
and Pi(1,15,n) will evaluate to 1307674368000 as n is multiplied from 1 to 15 which is equal to 15!

### Parenthesis less expression
If a expression is readable by human then it is readable by this evaluator. There is no need to wrap every function inside parenthesis.
For eg. sin90 will work totally fine instead of sin(90)


