/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpException;
import org.openqa.jetty.http.HttpFields;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.handler.AbstractHttpHandler;
import org.openqa.jetty.log.LogFactory;

public class ExpiryHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ExpiryHandler.class);
    private long _ttl = -1L;

    public void setTimeToLive(long ttl) {
        this._ttl = ttl;
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        log.debug("ExpiryHandler.handle()");
        String expires = this._ttl < 0L ? HttpFields.__01Jan1970 : HttpFields.formatDate(System.currentTimeMillis() + 1000L * this._ttl, false);
        response.setField("Expires", expires);
    }
}

