/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeUtil {
    private static final Log log = LogFactory.getLog(MimeUtil.class);
    public static final String ENC_QUOTED_PRINTABLE = "quoted-printable";
    public static final String ENC_BINARY = "binary";
    public static final String ENC_BASE64 = "base64";
    public static final String ENC_8BIT = "8bit";
    public static final String ENC_7BIT = "7bit";
    public static final String MIME_HEADER_MIME_VERSION = "mime-version";
    public static final String MIME_HEADER_CONTENT_ID = "content-id";
    public static final String MIME_HEADER_CONTENT_DESCRIPTION = "content-description";
    public static final String MIME_HEADER_CONTENT_DISPOSITION = "content-disposition";
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_MODIFICATION_DATE = "modification-date";
    public static final String PARAM_CREATION_DATE = "creation-date";
    public static final String PARAM_READ_DATE = "read-date";
    public static final String PARAM_SIZE = "size";
    public static final String MIME_HEADER_LANGAUGE = "content-language";
    public static final String MIME_HEADER_LOCATION = "content-location";
    public static final String MIME_HEADER_MD5 = "content-md5";
    private static final Random random = new Random();
    private static int counter = 0;
    private static final ThreadLocal<DateFormat> RFC822_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new Rfc822DateFormat();
        }
    };

    private MimeUtil() {
    }

    public static boolean isSameMimeType(String pType1, String pType2) {
        return pType1 != null && pType2 != null && pType1.equalsIgnoreCase(pType2);
    }

    public static boolean isMessage(String pMimeType) {
        return pMimeType != null && pMimeType.equalsIgnoreCase("message/rfc822");
    }

    public static boolean isMultipart(String pMimeType) {
        return pMimeType != null && pMimeType.toLowerCase().startsWith("multipart/");
    }

    public static boolean isBase64Encoding(String pTransferEncoding) {
        return ENC_BASE64.equalsIgnoreCase(pTransferEncoding);
    }

    public static boolean isQuotedPrintableEncoded(String pTransferEncoding) {
        return ENC_QUOTED_PRINTABLE.equalsIgnoreCase(pTransferEncoding);
    }

    public static Map<String, String> getHeaderParams(String pValue) {
        String rest;
        String main;
        pValue = pValue.trim();
        pValue = MimeUtil.unfold(pValue);
        HashMap<String, String> result = new HashMap<String, String>();
        if (pValue.indexOf(";") == -1) {
            main = pValue;
            rest = null;
        } else {
            main = pValue.substring(0, pValue.indexOf(";"));
            rest = pValue.substring(main.length() + 1);
        }
        result.put("", main);
        if (rest != null) {
            char[] chars = rest.toCharArray();
            StringBuilder paramName = new StringBuilder(64);
            StringBuilder paramValue = new StringBuilder(64);
            boolean READY_FOR_NAME = false;
            boolean IN_NAME = true;
            int READY_FOR_VALUE = 2;
            int IN_VALUE = 3;
            int IN_QUOTED_VALUE = 4;
            int VALUE_DONE = 5;
            int ERROR = 99;
            int state = 0;
            boolean escaped = false;
            block24: for (char c : chars) {
                switch (state) {
                    case 99: {
                        if (c != ';') continue block24;
                        state = 0;
                        continue block24;
                    }
                    case 0: {
                        if (c == '=') {
                            log.error("Expected header param name, got '='");
                            state = 99;
                            continue block24;
                        }
                        paramName.setLength(0);
                        paramValue.setLength(0);
                        state = 1;
                    }
                    case 1: {
                        if (c == '=') {
                            if (paramName.length() == 0) {
                                state = 99;
                                continue block24;
                            }
                            state = 2;
                            continue block24;
                        }
                        paramName.append(c);
                        continue block24;
                    }
                    case 2: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '\"': {
                                state = 4;
                                break;
                            }
                            default: {
                                state = 3;
                                fallThrough = true;
                            }
                        }
                        if (!fallThrough) continue block24;
                    }
                    case 3: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': 
                            case ';': {
                                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
                                state = 5;
                                fallThrough = true;
                                break;
                            }
                            default: {
                                paramValue.append(c);
                            }
                        }
                        if (!fallThrough) continue block24;
                    }
                    case 5: {
                        switch (c) {
                            case ';': {
                                state = 0;
                                continue block24;
                            }
                            case '\t': 
                            case ' ': {
                                continue block24;
                            }
                        }
                        state = 99;
                        continue block24;
                    }
                    case 4: {
                        switch (c) {
                            case '\"': {
                                if (!escaped) {
                                    result.put(paramName.toString().trim().toLowerCase(), paramValue.toString());
                                    state = 5;
                                    continue block24;
                                }
                                escaped = false;
                                paramValue.append(c);
                                continue block24;
                            }
                            case '\\': {
                                if (escaped) {
                                    paramValue.append('\\');
                                }
                                escaped = !escaped;
                                continue block24;
                            }
                        }
                        if (escaped) {
                            paramValue.append('\\');
                        }
                        escaped = false;
                        paramValue.append(c);
                    }
                }
            }
            if (state == 3) {
                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
            }
        }
        return result;
    }

    public static String createUniqueBoundary() {
        StringBuilder sb = new StringBuilder();
        sb.append("-=Part.");
        sb.append(Integer.toHexString(MimeUtil.nextCounterValue()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append('.');
        sb.append(Long.toHexString(System.currentTimeMillis()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append("=-");
        return sb.toString();
    }

    public static String createUniqueMessageId(String hostName) {
        StringBuilder sb = new StringBuilder("<Mime4j.");
        sb.append(Integer.toHexString(MimeUtil.nextCounterValue()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append('.');
        sb.append(Long.toHexString(System.currentTimeMillis()));
        if (hostName != null) {
            sb.append('@');
            sb.append(hostName);
        }
        sb.append('>');
        return sb.toString();
    }

    public static String formatDate(Date date, TimeZone zone) {
        DateFormat df = RFC822_DATE_FORMAT.get();
        if (zone == null) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(zone);
        }
        return df.format(date);
    }

    public static String fold(String s, int usedCharacters) {
        int maxCharacters = 76;
        int length = s.length();
        if (usedCharacters + length <= 76) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int lastLineBreak = -usedCharacters;
        int wspIdx = MimeUtil.indexOfWsp(s, 0);
        while (true) {
            if (wspIdx == length) {
                sb.append(s.substring(Math.max(0, lastLineBreak)));
                return sb.toString();
            }
            int nextWspIdx = MimeUtil.indexOfWsp(s, wspIdx + 1);
            if (nextWspIdx - lastLineBreak > 76) {
                sb.append(s.substring(Math.max(0, lastLineBreak), wspIdx));
                sb.append("\r\n");
                lastLineBreak = wspIdx;
            }
            wspIdx = nextWspIdx;
        }
    }

    public static String unfold(String s) {
        int length = s.length();
        for (int idx = 0; idx < length; ++idx) {
            char c = s.charAt(idx);
            if (c != '\r' && c != '\n') continue;
            return MimeUtil.unfold0(s, idx);
        }
        return s;
    }

    private static String unfold0(String s, int crlfIdx) {
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        if (crlfIdx > 0) {
            sb.append(s.substring(0, crlfIdx));
        }
        for (int idx = crlfIdx + 1; idx < length; ++idx) {
            char c = s.charAt(idx);
            if (c == '\r' || c == '\n') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static int indexOfWsp(String s, int fromIndex) {
        int len = s.length();
        for (int index = fromIndex; index < len; ++index) {
            char c = s.charAt(index);
            if (c != ' ' && c != '\t') continue;
            return index;
        }
        return len;
    }

    private static synchronized int nextCounterValue() {
        return counter++;
    }

    private static final class Rfc822DateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        public Rfc822DateFormat() {
            super("EEE, d MMM yyyy HH:mm:ss ", Locale.US);
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            int dstMillis;
            StringBuffer sb = super.format(date, toAppendTo, pos);
            int zoneMillis = this.calendar.get(15);
            int minutes = (zoneMillis + (dstMillis = this.calendar.get(16))) / 1000 / 60;
            if (minutes < 0) {
                sb.append('-');
                minutes = -minutes;
            } else {
                sb.append('+');
            }
            sb.append(String.format("%02d%02d", minutes / 60, minutes % 60));
            return sb;
        }
    }
}

