/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.ThreadPool;

public class IO
extends ThreadPool {
    private static Log log = LogFactory.getLog(IO.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static int bufferSize = Integer.getInteger("org.openqa.jetty.util.IO.bufferSize", 8192);
    private static NullOS __nullStream = new NullOS();
    private static NullWrite __nullWriter = new NullWrite();

    public static IO instance() {
        return Singleton.__instance;
    }

    public static void copyThread(InputStream in, OutputStream out) {
        try {
            IO.instance().run(new Job(in, out));
        }
        catch (InterruptedException e) {
            log.warn("EXCEPTION ", e);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copyThread(Reader in, Writer out) {
        try {
            IO.instance().run(new Job(in, out));
        }
        catch (InterruptedException e) {
            log.warn("EXCEPTION ", e);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L) {
                len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize);
                if (len != -1) {
                    byteCount -= (long)len;
                    out.write(buffer, 0, len);
                    continue;
                }
                break;
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L) {
                len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize);
                if (len != -1) {
                    byteCount -= (long)len;
                    out.write(buffer, 0, len);
                    continue;
                }
                break;
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(in, out);
        return new String(out.toByteArray());
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                IO.delete(files[i]);
                ++i;
            }
        }
        return file.delete();
    }

    @Override
    public void handle(Object o) {
        Job job = (Job)o;
        try {
            if (job.in != null) {
                IO.copy(job.in, job.out, -1L);
            } else {
                IO.copy(job.read, job.write, -1L);
            }
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            try {
                if (job.out != null) {
                    job.out.close();
                }
                if (job.write != null) {
                    job.write.close();
                }
            }
            catch (IOException e2) {
                LogSupport.ignore(log, e2);
            }
        }
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    static class Job {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.read = null;
            this.write = null;
        }

        Job(Reader read, Writer write) {
            this.in = null;
            this.out = null;
            this.read = read;
            this.write = write;
        }
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int i, int l) {
        }

        @Override
        public void write(int b) {
        }
    }

    private static class NullWrite
    extends Writer {
        private NullWrite() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] b) {
        }

        @Override
        public void write(char[] b, int o, int l) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(String s) {
        }

        @Override
        public void write(String s, int o, int l) {
        }
    }

    private static class Singleton {
        static final IO __instance = new IO();

        static {
            try {
                __instance.start();
            }
            catch (Exception e) {
                log.fatal(e);
                System.exit(1);
            }
        }

        private Singleton() {
        }
    }
}

