/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.io;

import java.io.IOException;
import java.util.Map;
import org.seleniumhq.jetty9.io.Connection;
import org.seleniumhq.jetty9.io.EndPoint;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;

public interface ClientConnectionFactory {
    public Connection newConnection(EndPoint var1, Map<String, Object> var2) throws IOException;

    public static class Helper {
        private static Logger LOG = Log.getLogger(Helper.class);

        private Helper() {
        }

        public static void replaceConnection(Connection oldConnection, Connection newConnection) {
            Helper.close(oldConnection);
            oldConnection.getEndPoint().setConnection(newConnection);
            Helper.open(newConnection);
        }

        private static void open(Connection connection) {
            try {
                connection.onOpen();
            }
            catch (Throwable x) {
                LOG.debug(x);
            }
        }

        private static void close(Connection connection) {
            try {
                connection.onClose();
            }
            catch (Throwable x) {
                LOG.debug(x);
            }
        }
    }
}

