/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.codec.ByteQueue;

public class QuotedPrintableInputStream
extends InputStream {
    private static Log log = LogFactory.getLog(QuotedPrintableInputStream.class);
    private InputStream stream;
    ByteQueue byteq = new ByteQueue();
    ByteQueue pushbackq = new ByteQueue();
    private byte state = 0;
    private boolean closed = false;

    public QuotedPrintableInputStream(InputStream stream) {
        this.stream = stream;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("QuotedPrintableInputStream has been closed");
        }
        this.fillBuffer();
        if (this.byteq.count() == 0) {
            return -1;
        }
        byte val = this.byteq.dequeue();
        if (val >= 0) {
            return val;
        }
        return val & 0xFF;
    }

    private void populatePushbackQueue() throws IOException {
        int i;
        if (this.pushbackq.count() != 0) {
            return;
        }
        block5: while (true) {
            i = this.stream.read();
            switch (i) {
                case -1: {
                    this.pushbackq.clear();
                    return;
                }
                case 9: 
                case 32: {
                    this.pushbackq.enqueue((byte)i);
                    continue block5;
                }
                case 10: 
                case 13: {
                    this.pushbackq.clear();
                    this.pushbackq.enqueue((byte)i);
                    return;
                }
            }
            break;
        }
        this.pushbackq.enqueue((byte)i);
    }

    private void fillBuffer() throws IOException {
        byte msdChar = 0;
        block6: while (this.byteq.count() == 0) {
            if (this.pushbackq.count() == 0) {
                this.populatePushbackQueue();
                if (this.pushbackq.count() == 0) {
                    return;
                }
            }
            byte b = this.pushbackq.dequeue();
            switch (this.state) {
                case 0: {
                    if (b != 61) {
                        this.byteq.enqueue(b);
                        continue block6;
                    }
                    this.state = 1;
                    continue block6;
                }
                case 1: {
                    if (b == 13) {
                        this.state = (byte)2;
                        continue block6;
                    }
                    if (b >= 48 && b <= 57 || b >= 65 && b <= 70 || b >= 97 && b <= 102) {
                        this.state = (byte)3;
                        msdChar = b;
                        continue block6;
                    }
                    if (b == 61) {
                        if (log.isWarnEnabled()) {
                            log.warn("Malformed MIME; got ==");
                        }
                        this.byteq.enqueue((byte)61);
                        continue block6;
                    }
                    if (log.isWarnEnabled()) {
                        log.warn("Malformed MIME; expected \\r or [0-9A-Z], got " + b);
                    }
                    this.state = 0;
                    this.byteq.enqueue((byte)61);
                    this.byteq.enqueue(b);
                    continue block6;
                }
                case 2: {
                    if (b == 10) {
                        this.state = 0;
                        continue block6;
                    }
                    if (log.isWarnEnabled()) {
                        log.warn("Malformed MIME; expected 10, got " + b);
                    }
                    this.state = 0;
                    this.byteq.enqueue((byte)61);
                    this.byteq.enqueue((byte)13);
                    this.byteq.enqueue(b);
                    continue block6;
                }
                case 3: {
                    if (b >= 48 && b <= 57 || b >= 65 && b <= 70 || b >= 97 && b <= 102) {
                        byte msd = this.asciiCharToNumericValue(msdChar);
                        byte low = this.asciiCharToNumericValue(b);
                        this.state = 0;
                        this.byteq.enqueue((byte)(msd << 4 | low));
                        continue block6;
                    }
                    if (log.isWarnEnabled()) {
                        log.warn("Malformed MIME; expected [0-9A-Z], got " + b);
                    }
                    this.state = 0;
                    this.byteq.enqueue((byte)61);
                    this.byteq.enqueue(msdChar);
                    this.byteq.enqueue(b);
                    continue block6;
                }
            }
            log.error("Illegal state: " + this.state);
            this.state = 0;
            this.byteq.enqueue(b);
        }
    }

    private byte asciiCharToNumericValue(byte c) {
        if (c >= 48 && c <= 57) {
            return (byte)(c - 48);
        }
        if (c >= 65 && c <= 90) {
            return (byte)(10 + (c - 65));
        }
        if (c >= 97 && c <= 122) {
            return (byte)(10 + (c - 97));
        }
        throw new IllegalArgumentException((char)c + " is not a hexadecimal digit");
    }
}

