/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs.bc;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProviderBuilder
implements PKCS12MacCalculatorBuilderProvider {
    private ExtendedDigest digest;
    private AlgorithmIdentifier digestAlgorithmIdentifier;

    public BcPKCS12MacCalculatorBuilderProviderBuilder() {
        this(new SHA1Digest(), new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE));
    }

    public BcPKCS12MacCalculatorBuilderProviderBuilder(ExtendedDigest extendedDigest, AlgorithmIdentifier algorithmIdentifier) {
        this.digest = extendedDigest;
        this.digestAlgorithmIdentifier = algorithmIdentifier;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(BcPKCS12MacCalculatorBuilderProviderBuilder.this.digestAlgorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProviderBuilder.this.digest, pKCS12PBEParams, cArray);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return BcPKCS12MacCalculatorBuilderProviderBuilder.this.digestAlgorithmIdentifier;
            }
        };
    }
}

