<script>
import firebase from 'firebase';
export default {
  name: 'Header',
  data () {
    return {
      sitename: "Skład dla zwierzaków :: Vue.js"
    }
},
props: ['cartItemCount'],
  beforeCreate() {
      firebase.auth().onAuthStateChanged((user)=> {
          this.$store.commit('SET_SESSION', user || false)
      });
  },
  methods: {
    showCheckout() {
      this.$router.push({name: 'Form'});
    },
    signIn() {
      let provider = new firebase.auth.GoogleAuthProvider();
      firebase.auth().signInWithPopup(provider).then(function(result) {
        console.log('zalogowano!');
      }).catch(function(error){
        console.log('błąd ' + error)
      });
    },
    signOut() {
      firebase.auth().signOut().then(function() {
        // Pomyślnie wylogowano.
        console.log("wylogowano!")
      }).catch(function(error) {
        console.log("błąd podczas wylogowywania!")
        // Wystąpił błąd.
      });
    }
  },
  computed: {
    mySession() {
      return this.$store.getters.session;
    }
  }
}
</script>
