namespace ListBoxForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.Text = "ListBoxForm";
            this.Width = 348;
            this.Height = 508;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // ListBox
            ListBox listBox1 = new ListBox();
            listBox1.Size = new Size(300, 400);
            listBox1.Location = new Point(12, 12);
            listBox1.Name = "listBox1";

            listBox1.MultiColumn = false;
          
            listBox1.SelectionMode = SelectionMode.One;
           
            for (int x = 1; x < 21; x++)
            {
                listBox1.Items.Add("Item " + x.ToString());
            }

            listBox1.SetSelected(0, true);

            this.Controls.Add(listBox1);

            // Button
            Button firstButton = new Button();
            firstButton.Location = new Point(12, 403);
            firstButton.Text = "Get Value";

            firstButton.Height = 35;
            firstButton.Width = 300;

            firstButton.Click += new EventHandler(firstButton_Click);

            Controls.Add(firstButton);
        }

        private void firstButton_Click(object sender, EventArgs e)
        {
            try
            {
                if (((ListBox)Controls["listBox1"]).SelectedItem != null)
                {
                    string SelectedListBox = ((ListBox)Controls["listBox1"]).SelectedItem.ToString();

                    MessageBox.Show(SelectedListBox, "Selected", MessageBoxButtons.OK);
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}