namespace ColorDialogForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.Text = "ColorDialogForm";
            this.Width = 500;
            this.Height = 300;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // colorDialog
            ColorDialog colorDialog1 = new ColorDialog();
            colorDialog1.AllowFullOpen = true;
            colorDialog1.ShowHelp = true;
            colorDialog1.Color = Color.Blue;

            // Button
            Button openDialog1 = new Button();
            openDialog1.Location = new Point(12, 12);
            openDialog1.Text = "Open Color Dialog";

            openDialog1.Height = 35;
            openDialog1.Width = 455;

            openDialog1.Click += new EventHandler(openDialog1_Click);

            Controls.Add(openDialog1);
        }

        private void openDialog1_Click(object sender, EventArgs e)
        {
            try
            {
                if(colorDialog1.ShowDialog() == DialogResult.OK)
                {
                    this.BackColor = colorDialog1.Color;
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}