using System.Text;

namespace SaveFileDialogForm
{
    public partial class Form1 : Form
    {
        TextBox textToFile = new TextBox();
        public Form1()
        {
            InitializeComponent();

            this.Text = "SaveFileDialogForm";
            this.Width = 547;
            this.Height = 477;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // Input
            textToFile.Name = "textToFile";
            textToFile.Location = new Point(12, 12);
            textToFile.Width = 500;
            textToFile.Height = 350;
            textToFile.Multiline = true;
            textToFile.ScrollBars = ScrollBars.Both;
            textToFile.WordWrap = false;

            Controls.Add(textToFile);

            // Button
            Button saveFileDialog1Button = new Button();
            saveFileDialog1Button.Location = new Point(12, 375);
            saveFileDialog1Button.Name = "saveFileDialog1Button";
            saveFileDialog1Button.Size = new Size(500, 35);
            saveFileDialog1Button.TabIndex = 1;
            saveFileDialog1Button.Text = "Save File";
            saveFileDialog1Button.UseVisualStyleBackColor = true;
            saveFileDialog1Button.Click += new EventHandler(saveFileDialog1Button_Click);
            Controls.Add(saveFileDialog1Button);
        }

        private void saveFileDialog1Button_Click(object sender, EventArgs e)
        {
            try
            {
                if (textToFile.Text == "")
                {
                    MessageBox.Show("The field for entering text was left blank.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
                else
                {
                    using (SaveFileDialog saveFileDialog1 = new SaveFileDialog())
                    {
                        saveFileDialog1.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*";
                        saveFileDialog1.FilterIndex = 1;
                        saveFileDialog1.DefaultExt = "txt";
                        saveFileDialog1.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
                        saveFileDialog1.RestoreDirectory = true;
                        //saveFileDialog1.CheckFileExists = true;
                        //saveFileDialog1.CheckPathExists = true;

                        if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                        {
                            FileStream streamToFile = new FileStream(saveFileDialog1.FileName, FileMode.CreateNew);

                            using (StreamWriter writeToFile = new StreamWriter(streamToFile, Encoding.UTF8))
                            {
                                writeToFile.Write(textToFile.Text);
                            }

                            MessageBox.Show("File was saved.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}