namespace OpenFileDialogForm
{
    public partial class Form1 : Form
    {

        TextBox textFromFile = new TextBox();
        public Form1()
        {
            InitializeComponent();

            this.Text = "OpenFileDialogForm";
            this.Width = 547;
            this.Height = 477;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // Input
            textFromFile.Name = "textFromFile";
            textFromFile.Location = new Point(12, 12);
            textFromFile.Width = 500;
            textFromFile.Height = 350;
            textFromFile.Multiline = true;
            textFromFile.ScrollBars = ScrollBars.Both;
            textFromFile.WordWrap = false;
            Controls.Add(textFromFile);

            // Button
            Button openFileDialog1Button = new Button();
            openFileDialog1Button.Location = new Point(12, 375);
            openFileDialog1Button.Name = "openFileDialog1Button1";
            openFileDialog1Button.Size = new Size(500, 35);
            openFileDialog1Button.TabIndex = 1;
            openFileDialog1Button.Text = "Open File";
            openFileDialog1Button.UseVisualStyleBackColor = true;
            openFileDialog1Button.Click += new EventHandler(openFileDialog1Button_Click);
            Controls.Add(openFileDialog1Button);
        }

        private void openFileDialog1Button_Click(object sender, EventArgs e)
        {
            try
            {
                string selectedFileContent;
                string selectedFilePath;

                using (OpenFileDialog openFileDialog = new OpenFileDialog())
                {
                    openFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
                    openFileDialog.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*";
                    openFileDialog.FilterIndex = 1;
                    openFileDialog.RestoreDirectory = true;
                    openFileDialog.Multiselect = false;

                    if (openFileDialog.ShowDialog() == DialogResult.OK)
                    {
                        selectedFilePath = openFileDialog.FileName;

                        using (StreamReader reader = new StreamReader(selectedFilePath))
                        {
                            selectedFileContent = reader.ReadToEnd();
                        }

                        textFromFile.Text = selectedFileContent;
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}