namespace NumericUpDownForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.Text = "NumericUpDownForm";
            this.Width = 548;
            this.Height = 193;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // NumericUpDown
            NumericUpDown firstNumericUpDown = new NumericUpDown();
            firstNumericUpDown.Location = new Point(12, 12);
            firstNumericUpDown.Name = "firstNumericUpDown";

            firstNumericUpDown.Width = 500;
            firstNumericUpDown.Height = 25;

            firstNumericUpDown.Minimum = -25;
            firstNumericUpDown.Maximum = 25;

            firstNumericUpDown.Value = 10;

            firstNumericUpDown.ValueChanged += new System.EventHandler(firstNumericUpDown_ValueChanged);

            Controls.Add(firstNumericUpDown);

            // Button
            Button firstButton = new Button();
            firstButton.Location = new Point(12, 52);

            firstButton.Text = "Value from Numeric field to Text field.";

            firstButton.Height = 35;
            firstButton.Width = 500;

            firstButton.Click += new EventHandler(firstButton_Click);

            Controls.Add(firstButton);

            // Input
            TextBox firstInput = new TextBox();
            firstInput.Name = "inputBoxInForm";
            firstInput.Location = new Point(12, 95);

            firstInput.Width = 500;
            firstInput.Height = 25;

            Controls.Add(firstInput);
        }
           
        private void firstNumericUpDown_ValueChanged(object sender, EventArgs e)  
        {
            try
            {
                var ValueOfField = ((NumericUpDown)Controls["firstNumericUpDown"]).Value;

                int ValueOfNumericField = Convert.ToInt32(ValueOfField);

                if (ValueOfNumericField == null)
                {
                    MessageBox.Show("Value in field is not set!", "Error", MessageBoxButtons.OK);
                }
                else
                {
                    if(ValueOfNumericField > 20)
                    {
                        MessageBox.Show("Value field is higher than 20!", "Error", MessageBoxButtons.OK);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }

        private void firstButton_Click(object sender, EventArgs e)
        {
            try
            { 
                var ValueOfField = ((NumericUpDown)Controls["firstNumericUpDown"]).Value;

                string ValueOfFieldString = ValueOfField.ToString();

                ((TextBox)Controls["inputBoxInForm"]).Text = ValueOfFieldString;

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }

        }

    }
}