namespace FontDialogForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.Text = "FontDialogForm";
            this.Width = 395;
            this.Height = 190;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // TextBox
            TextBox textBoxExample = new TextBox();
            textBoxExample.Location = new Point(12, 12);
            textBoxExample.Name = "textBoxExample";
            textBoxExample.AutoSize = false;
            textBoxExample.Width = 350;
            textBoxExample.Height = 60;
            textBoxExample.TabIndex = 0;
            textBoxExample.Text = "Text example";
            textBoxExample.TextAlign = HorizontalAlignment.Center;
            Controls.Add(textBoxExample);

            // Button
            Button SetFontButton = new Button();
            SetFontButton.Location = new Point(12, 83);
            SetFontButton.Name = "SetFontButton";
            SetFontButton.Size = new Size(350, 35);
            SetFontButton.TabIndex = 1;
            SetFontButton.Text = "Set Font";
            SetFontButton.UseVisualStyleBackColor = true;
            SetFontButton.Click += new EventHandler(SetFontButton_Click);
            Controls.Add(SetFontButton);

            // FontDialog
            FontDialog fontDialog1 = new FontDialog();


            fontDialog1.ShowColor = true;

            fontDialog1.Font = textBoxExample.Font;
            fontDialog1.Color = textBoxExample.ForeColor;
        }

        private void SetFontButton_Click(object sender, EventArgs e)
        {
            try
            {
                if (fontDialog1.ShowDialog() == DialogResult.OK)
                {
                    ((TextBox)Controls["textBoxExample"]).Font = fontDialog1.Font;
                    ((TextBox)Controls["textBoxExample"]).ForeColor = fontDialog1.Color;
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}