namespace ComboBoxForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.Text = "ComboBoxForm";
            this.Width = 346;
            this.Height = 162;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // ComboBox
            ComboBox comboBox1 = new ComboBox();

            comboBox1.Size = new Size(300, 21);
            comboBox1.Location = new Point(12, 12);
            comboBox1.Name = "comboBox1";

            comboBox1.DropDownWidth = 280;

            for (int i = 0; i < 21; i++)
            {
                comboBox1.Items.Add("Item " + i.ToString());
            }

            comboBox1.DropDownStyle = ComboBoxStyle.DropDownList;

            this.Controls.Add(comboBox1);

            // Button
            Button firstButton = new Button();
            firstButton.Location = new Point(12, 56);
            firstButton.Text = "Get Value";

            firstButton.Height = 35;
            firstButton.Width = 300;

            firstButton.Click += new EventHandler(firstButton_Click);

            Controls.Add(firstButton);
        }

        private void firstButton_Click(object sender, EventArgs e)
        {
            try
            {
                if (((ComboBox)Controls["comboBox1"]).SelectedItem != null)
                {
                    string SelectedComboBox = ((ComboBox)Controls["comboBox1"]).SelectedItem.ToString();

                    MessageBox.Show(SelectedComboBox, "Selected", MessageBoxButtons.OK);
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}