namespace CheckedListBoxForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.Text = "CheckedListBoxForm";
            this.Width = 349;
            this.Height = 523;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // ListBox
            CheckedListBox checkedListBox1 = new CheckedListBox();
            checkedListBox1.Size = new Size(300, 400);
            checkedListBox1.Location = new Point(12, 12);
            checkedListBox1.Name = "checkedListBox1";

            checkedListBox1.MultiColumn = false;

            checkedListBox1.SelectionMode = SelectionMode.One;

            for (int x = 1; x < 21; x++)
            {
                checkedListBox1.Items.Add("Item " + x.ToString());
            }

            this.Controls.Add(checkedListBox1);

            // Button
            Button firstButton = new Button();
            firstButton.Location = new Point(12, 420);
            firstButton.Text = "Get Value";

            firstButton.Height = 35;
            firstButton.Width = 300;

            firstButton.Click += new EventHandler(firstButton_Click);

            Controls.Add(firstButton);
        }

        private void firstButton_Click(object sender, EventArgs e)
        {
            try
            {
                if (((CheckedListBox)Controls["checkedListBox1"]).CheckedItems.Count > 0)
                {
                    foreach (object itemChecked in ((CheckedListBox)Controls["checkedListBox1"]).CheckedItems)
                    {
                        MessageBox.Show("Item: " + itemChecked.ToString() + " is checked.", "Checked", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                }
                else
                {
                    MessageBox.Show("None of the items are checked.", "Checked", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}