﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Singleton
{
    public static class KlasaStatyczna
    {
        private static string pole = "Domyślna wartość pola";

        public static string Własność
        {
            get
            {
                return pole;  
            }
            set
            {
                pole = value;
            }
        }

        public static void Metoda()
        {
            Console.WriteLine(pole);
        }
    }

    public sealed class InstancjaWStatycznymPolu
    {
        private static readonly InstancjaWStatycznymPolu instancja = new InstancjaWStatycznymPolu();

        private InstancjaWStatycznymPolu() { }

        public static InstancjaWStatycznymPolu Instancja
        {
            get
            {
                return instancja;
            }
        }

        private string pole = "Domyślna wartość pola";

        public string Własność
        {
            get
            {
                return pole;
            }
            set
            {
                pole = value;
            }
        }
     
        public void Metoda()
        {
            Console.WriteLine(pole);
        }
    }

    public sealed class KontrolaLiczbyInstancji
    {
        private static KontrolaLiczbyInstancji instancja;

        private KontrolaLiczbyInstancji() { }

        public static KontrolaLiczbyInstancji Instancja
        {
            get
            {
                if (instancja == null) instancja = new KontrolaLiczbyInstancji();
                return instancja;
            }
        }

        private string pole = "Domyślna wartość pola";

        public string Własność
        {
            get
            {
                return pole;
            }
            set
            {
                pole = value;
            }
        }

        public void Metoda()
        {
            Console.WriteLine(pole);
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            //klasa statyczna
            KlasaStatyczna.Własność = "Wartość pola ustalona w metodzie Program.Main";
            KlasaStatyczna.Metoda();

            Console.WriteLine();

            //instancja w statycznym polu            
            InstancjaWStatycznymPolu.Instancja.Własność = "Wartość pola ustalona w metodzie Program.Main";
            InstancjaWStatycznymPolu.Instancja.Metoda();

            Console.WriteLine();

            InstancjaWStatycznymPolu referencja_iwsp = InstancjaWStatycznymPolu.Instancja;
            referencja_iwsp.Własność = "Wartość pola ustalona w metodzie Program.Main";
            referencja_iwsp.Metoda();

            Console.WriteLine();

            //kontrola liczby instancji
            KontrolaLiczbyInstancji.Instancja.Własność = "Wartość pola ustalona w metodzie Program.Main";
            KontrolaLiczbyInstancji.Instancja.Metoda();

            Console.WriteLine();

            KontrolaLiczbyInstancji referencja_kli = KontrolaLiczbyInstancji.Instancja;
            referencja_kli.Własność = "Wartość pola ustalona w metodzie Program.Main";
            referencja_kli.Metoda();
        }
    }
}
