﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Helion;

namespace UlamekTestyJednostkowe
{
    [TestClass]
    public class UlamekTesty
    {
        private Random r = new Random();        

        private int losujLiczbeCalkowita(int? maksymalnaBezwzglednaWartosc = null)
        {
            if (!maksymalnaBezwzglednaWartosc.HasValue)
                return r.Next(int.MinValue, int.MaxValue);
            else
            {
                maksymalnaBezwzglednaWartosc = Math.Abs(maksymalnaBezwzglednaWartosc.Value);
                return r.Next(-maksymalnaBezwzglednaWartosc.Value, maksymalnaBezwzglednaWartosc.Value);
            }
        }

        private int losujLiczbeCalkowitaRoznaOdZera(int? maksymalnaBezwzglednaWartosc = null)
        {
            int wartosc;
            do
            {
                wartosc = losujLiczbeCalkowita(maksymalnaBezwzglednaWartosc);
            }
            while (wartosc == 0);
            return wartosc;
        }

        [TestMethod]
        public void TestKonstruktoraIWlasnosci()
        {
            //przygotowania (assert)
            int licznik = losujLiczbeCalkowita();
            int mianownik = losujLiczbeCalkowitaRoznaOdZera();

            //działanie (act)
            Ulamek u = new Ulamek(licznik, mianownik);

            //weryfikacja (assert)
            Assert.AreEqual(licznik, u.Licznik, "Niezgodność w liczniku");
            Assert.AreEqual(mianownik, u.Mianownik, "Niezgodność w mianowniku");
        }

        [TestMethod]
        public void TestKonstruktora()
        {
            //przygotowania (assert)
            int licznik = losujLiczbeCalkowita();
            int mianownik = losujLiczbeCalkowitaRoznaOdZera();

            //działanie (act)
            Ulamek u = new Ulamek(licznik, mianownik);

            //weryfikacja (assert)
            PrivateObject po = new PrivateObject(u);
            int u_licznik = (int)po.GetField("licznik");
            int u_mianownik = (int)po.GetField("mianownik");            
            Assert.AreEqual(licznik, u_licznik, "Niezgodność w liczniku");
            Assert.AreEqual(mianownik, u_mianownik, "Niezgodność w mianowniku");            
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestKonstruktoraWyjatek()
        {
            Ulamek u = new Ulamek(losujLiczbeCalkowita(), 0);
        }

        [TestMethod]
        public void TestPolaStatycznegoPolowa()
        {
            Ulamek uP = Ulamek.Polowa;
            Assert.AreEqual(1, uP.Licznik);
            Assert.AreEqual(2, uP.Mianownik);
        }

        [TestMethod]
        public void TestMetodyUprosc()
        {
            Ulamek u = new Ulamek(4, -2);

            u.Uprosc();

            Assert.AreEqual(-2, u.Licznik);
            Assert.AreEqual(1, u.Mianownik);
        }

        [TestMethod]
        public void TestOperatorow()
        {
            Ulamek a = Ulamek.Polowa;
            Ulamek b = Ulamek.Cwierc;

            Assert.AreEqual(new Ulamek(3, 4), a + b, "Niepowodzenie przy dodawaniu");
            Assert.AreEqual(Ulamek.Cwierc, a - b, "Niepowodzenie przy odejmowaniu");
            Assert.AreEqual(new Ulamek(1, 8), a * b, "Niepowodzenie przy mnożeniu");
            Assert.AreEqual(new Ulamek(2), a / b, "Niepowodzenie przy dzieleniu");
        }

        [TestMethod]
        public void TestSortowania()
        {
            Ulamek[] tablica = new Ulamek[100];
            for (int i = 0; i < tablica.Length; i++)
                tablica[i] = new Ulamek(losujLiczbeCalkowita(), losujLiczbeCalkowitaRoznaOdZera());

            Array.Sort(tablica);

            bool tablicaJestPosortowanaRosnaco = true;
            for (int i = 0; i < tablica.Length - 1; i++)
                if (tablica[i] >= tablica[i + 1]) tablicaJestPosortowanaRosnaco = false;
            Assert.IsTrue(tablicaJestPosortowanaRosnaco);
        }

        const int liczbaPowtorzen = 100;

        [TestMethod]
        public void TestKonwersjiDoDouble()
        {
            for (int i = 0; i < liczbaPowtorzen; ++i)
            {
                int licznik = losujLiczbeCalkowita();
                int mianownik = losujLiczbeCalkowitaRoznaOdZera();
                Ulamek u = new Ulamek(licznik, mianownik);

                double d = (double)u;

                Assert.AreEqual(licznik / (double)mianownik, d);
            }
        }

        [TestMethod]
        public void TestKonwersjiZInt()
        {
            for (int i = 0; i < liczbaPowtorzen; ++i)
            {
                int licznik = losujLiczbeCalkowita();
                
                Ulamek u = licznik;
                
                Assert.AreEqual(licznik, u.Licznik);
                Assert.AreEqual(1, u.Mianownik);
            }
        }        

        [TestMethod]
        public void TestMetodyUprosc_Losowy()
        {
            for (int i = 0; i < liczbaPowtorzen; ++i)
            {
                Ulamek u = new Ulamek(losujLiczbeCalkowita(), losujLiczbeCalkowitaRoznaOdZera());
                Ulamek kopia = u; //klonowanie
                
                u.Uprosc();

                Assert.IsTrue(u.Mianownik > 0);
                Assert.AreEqual(kopia.ToDouble(), u.ToDouble());
            }
        }

        [TestMethod]
        public void TestOperatorow_Losowy()
        {
            int limit = (int)(Math.Sqrt(int.MaxValue / 2) - 1); //ograniczenie maksymalnej wartosci
            const double dokladnosc = 1E-10;
            for (int i = 0; i < liczbaPowtorzen; ++i)
            {
                Ulamek a = new Ulamek(losujLiczbeCalkowita(limit), losujLiczbeCalkowitaRoznaOdZera(limit));
                Ulamek b = new Ulamek(losujLiczbeCalkowita(limit), losujLiczbeCalkowitaRoznaOdZera(limit));

                double suma = (a + b).ToDouble();
                double roznica = (a - b).ToDouble();
                double iloczyn = (a * b).ToDouble();
                double iloraz = (a / b).ToDouble();
            
                Assert.AreEqual(a.ToDouble() + b.ToDouble(), suma, dokladnosc, "Niepowodzenie przy dodawaniu");
                Assert.AreEqual(a.ToDouble() - b.ToDouble(), roznica, dokladnosc, "Niepowodzenie przy odejmowaniu");
                Assert.AreEqual(a.ToDouble() * b.ToDouble(), iloczyn, dokladnosc, "Niepowodzenie przy mnożeniu");
                Assert.AreEqual(a.ToDouble() / b.ToDouble(), iloraz, dokladnosc, "Niepowodzenie przy dzieleniu");
            }

        }
    }
}
