﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SystemInfo
{
    class Program
    {
        //Informacje o systemie
        static private string system = "Informacje o systemie:"
           + "\nWersja systemu: " + Environment.OSVersion
           + (Environment.Is64BitOperatingSystem?", 64 bitowy":"")
           + "\nWersja Microsoft .NET Framework: " + Environment.Version
           + "\nNazwa komputera: " + Environment.MachineName
           + "\nKatalog systemowy: " + Environment.SystemDirectory;

        //Informacje o bieżącym użytkowniku
        static private string użytkownik = "Informacje o bieżącym użytkowniku:"
           + "\nNazwa użytkownika: " + Environment.UserName
           + "\nKatalogi specjalne użytkownika:"
           + "\nkatalog 'Moje dokumenty' = " + Environment.GetFolderPath(Environment.SpecialFolder.Personal)
           + "\nkatalog 'Pulpit' = " + Environment.GetFolderPath(Environment.SpecialFolder.Desktop)
           + "\nkatalog 'Moje obrazy' = " + Environment.GetFolderPath(Environment.SpecialFolder.MyPictures)
           + "\nkatalog menu Start = " + Environment.GetFolderPath(Environment.SpecialFolder.StartMenu)
           + "\nkatalog 'Programy' = " + Environment.GetFolderPath(Environment.SpecialFolder.Programs)
           + "\nkatalog 'Autostart' = " + Environment.GetFolderPath(Environment.SpecialFolder.Startup)
           + "\nkatalog domowy użytkownika = " + Environment.GetFolderPath(Environment.SpecialFolder.UserProfile);

        static void Main(string[] args)
        {
           //Jest katalog domowy!!!!!!!!!!!!!!! 

            Console.WriteLine("SystemInfo\n----------\n");
            Console.WriteLine(system + "\n");
            Console.WriteLine(użytkownik + "\n");
            
            Console.WriteLine("Katalog domowy użytkownika = " + Environment.GetEnvironmentVariable("USERPROFILE"));
            
            //Zmienne środowiskowe
            string zmienne = "";
            System.Collections.IDictionary zmienneSrodowiskowe = Environment.GetEnvironmentVariables();
            foreach (System.Collections.DictionaryEntry zmienna in zmienneSrodowiskowe)
                zmienne += zmienna.Key + " = " + zmienna.Value + "\n";
            //Console.WriteLine("\nZmienne środowiskowe:\n" + zmienne);

            //Dyski logiczne
            string[] dyski = Environment.GetLogicalDrives();
            string driveinfo = "\nDyski: ";
            foreach (string dysk in dyski) driveinfo += dysk + " ";
            Console.WriteLine(driveinfo + "\n");
        }
    }
}
