// GniazdaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Gniazda.h"
#include "GniazdaDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGniazdaDlg dialog

CGniazdaDlg::CGniazdaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGniazdaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGniazdaDlg)
	m_strKomunikat = _T("");
//	m_sRecvd = _T("");
//	m_sSent = _T("");
	m_strNazwa = _T("");
	m_iTyp = -1;
	m_iPort = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGniazdaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGniazdaDlg)
	DDX_Control(pDX, IDC_LWYSLANE, m_ctlWyslane);
	DDX_Control(pDX, IDC_LODEBRANE, m_ctlOdebrane);
	DDX_Control(pDX, IDC_PPOLACZ, m_ctlPolacz);
	DDX_Text(pDX, IDC_EKNKAT,m_strKomunikat);
	DDX_Text(pDX, IDC_ENAZWASWR, m_strNazwa);
	DDX_Radio(pDX, IDC_OKLIENT, m_iTyp);
	DDX_Text(pDX, IDC_EPORTSWR, m_iPort);
//	DDX_Text(pDX, IDC_ERECVD, m_sRecvd);
//	DDX_Text(pDX, IDC_ESENT, m_sSent);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGniazdaDlg, CDialog)
	//{{AFX_MSG_MAP(CGniazdaDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OKLIENT, OnTypPo)
	ON_BN_CLICKED(IDC_PPOLACZ, OnPpolacz)
	ON_BN_CLICKED(IDC_PWYSLIJ, OnPwyslij)
	ON_BN_CLICKED(IDC_OSERWER, OnTypPo)
	ON_BN_CLICKED(IDC_PZAMKNIJ, OnPzamknij)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGniazdaDlg message handlers

BOOL CGniazdaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	// Inicjalizacja zmiennych obiektw kontrolnych
	m_iTyp = 0;
	m_strNazwa = "loopback";
	m_iPort = 4000;
	m_bPolaczone = FALSE;
	// Uaktualnienie obiektw kontrolnych
	UpdateData(FALSE);
	// Ustawienie wskanikw do oknien nadrzdnych
	m_sGniazdoPoloczenia.UstawOjca(this);
	m_sGniazdoSluchajace.UstawOjca(this);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGniazdaDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGniazdaDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGniazdaDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGniazdaDlg::OnTypPo() 
{
	// TODO: Add your control notification handler code here
	// Synchronizowanie zmiennych z obiektami kontrolnymi
	UpdateData(TRUE);
	// Jaki tryb jest aktywny?
	if (m_iTyp == 0)	// Ustawienie odpowiedniej etykiety na przycisku
		m_ctlPolacz.SetWindowText("P&ocz");
	else
		m_ctlPolacz.SetWindowText("S&chaj");
}

void CGniazdaDlg::OnPpolacz() 
{
	// TODO: Add your control notification handler code here
	// Synchronizowanie zmiennych z obiektami kontrolnymi
	UpdateData(TRUE);
	// Wyczenie dostpu do kontrolek poczenia i wpisywania komunikatw
	GetDlgItem(IDC_PPOLACZ)->EnableWindow(FALSE);
	GetDlgItem(IDC_ENAZWASWR)->EnableWindow(FALSE);
	GetDlgItem(IDC_EPORTSWR)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATICNAZWA)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATICPORT)->EnableWindow(FALSE);
	GetDlgItem(IDC_OKLIENT)->EnableWindow(FALSE);
	GetDlgItem(IDC_OSERWER)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATICTYP)->EnableWindow(FALSE);
	// W jakim trybie pracuje ta aplikacja?
	if (m_iTyp == 0)
	{
		// Klient, utworzenie domylnego gniazda
		m_sGniazdoPoloczenia.Create();
		// Otwarcie poczenia z serwerem
		m_sGniazdoPoloczenia.Connect(m_strNazwa, m_iPort);
	}
	else
	{
		// Serwer, Utworzenie gniazda i przyczenie go do okrelonego portu
		m_sGniazdoSluchajace.Create(m_iPort);
		// Nasuchiwanie w oczekiwaniu na poczenie
		m_sGniazdoSluchajace.Listen();
	}
}

void CGniazdaDlg::OnAccept()
{
	if (m_bPolaczone)
	{
		// Utworzenie gniazda odmowy poczenia
		CAsyncSocket sGzdoOdmowy;
		// Utworzenie komunikatu do wysania
		CString strKom = "Za duo pocze, Sprbuj ponownie pniej.";
		// Zaakceptowanie dania poczenia
		m_sGniazdoSluchajace.Accept(sGzdoOdmowy);
		// Wysanie komunikatu o odmowie poczenia
		sGzdoOdmowy.Send(LPCTSTR(strKom), strKom.GetLength());
		// Zamknicie gniazda
		sGzdoOdmowy.Close();
	}
	else
	{
		// Zaakceptiowanie dania poczenia
		m_sGniazdoSluchajace.Accept(m_sGniazdoPoloczenia);
		m_bPolaczone = TRUE;
		// Uaktywnienie obiektw zwizanych z wysyaniem komunikatw
		GetDlgItem(IDC_EKNKAT)->EnableWindow(TRUE);
		GetDlgItem(IDC_PWYSLIJ)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATICKNKAT)->EnableWindow(TRUE);
	}
}

void CGniazdaDlg::OnConnect()
{
	// Uaktywnienie tekstu i kontrolek sucych przesyaniu komunikatw
	GetDlgItem(IDC_EKNKAT)->EnableWindow(TRUE);
	GetDlgItem(IDC_PWYSLIJ)->EnableWindow(TRUE);
	GetDlgItem(IDC_STATICKNKAT)->EnableWindow(TRUE);
	GetDlgItem(IDC_PZAMKNIJ)->EnableWindow(TRUE);
}

void CGniazdaDlg::OnClose()
{
	// Zamknicie poczenia z gniazdem
	m_sGniazdoPoloczenia.Close();
	m_bPolaczone = FALSE;
	// Wyczenie dostpu do kontrolek sucych wysyaniu komunikatw
	GetDlgItem(IDC_EKNKAT)->EnableWindow(FALSE);
	GetDlgItem(IDC_PWYSLIJ)->EnableWindow(FALSE);
	GetDlgItem(IDC_STATICKNKAT)->EnableWindow(FALSE);
	GetDlgItem(IDC_PZAMKNIJ)->EnableWindow(FALSE);
	// Czy ta aplikacja pracuje jako klient?
	if (m_iTyp == 0)
	{
		// Tak, udostpnienie kontrolek konfiguracji poczenia
		GetDlgItem(IDC_PPOLACZ)->EnableWindow(TRUE);
		GetDlgItem(IDC_ENAZWASWR)->EnableWindow(TRUE);
		GetDlgItem(IDC_EPORTSWR)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATICNAZWA)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATICPORT)->EnableWindow(TRUE);
		GetDlgItem(IDC_OKLIENT)->EnableWindow(TRUE);
		GetDlgItem(IDC_OSERWER)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATICTYP)->EnableWindow(TRUE);
	}
}

void CGniazdaDlg::OnReceive()
{
	char *pBuf = new char[1025];
	int iBufRozm = 1024;
	int iOdebrano;
	CString strOdebrany;

	// Odebranie komunikatu
	iOdebrano = m_sGniazdoPoloczenia.Receive(pBuf, iBufRozm);
	// Czy cokolwiek zostao odebrane
	if (iOdebrano == SOCKET_ERROR)
	{
	}
	else
	{
		// Wstawienie znaku koca komunikatu
		pBuf[iOdebrano] = NULL;
		// Skopiowanie komunikatu do obiektu klasy CString
		strOdebrany = pBuf;
		// Dodanie komunikatu do listy komunikatw odebranych
		m_ctlOdebrane.AddString(strOdebrany);
		// Uaktualnienie okna dialogowego
		UpdateData(FALSE);
	}
}

void CGniazdaDlg::OnSend()
{
}

void CGniazdaDlg::OnPwyslij() 
{
	// TODO: Add your control notification handler code here
	int iDlugosc;
	int iWyslanie;

	// Synchronizowanie zmiennych z obiektami kontrolnymi
	UpdateData(TRUE);
	// Czy jest jaki komunikat do wysania?
	if (m_strKomunikat != "")
	{
		// Pobranie dugoci komunikatu
		iDlugosc = m_strKomunikat.GetLength();
		// Wysanie komunikatu
		iWyslanie = m_sGniazdoPoloczenia.Send(LPCTSTR(m_strKomunikat), iDlugosc);
		// Czy komunikat zosta wysany pomylnie?
		if (iWyslanie == SOCKET_ERROR)
		{
		}
		else
		{
			// Dodanie komunikatu do listy
			m_ctlWyslane.AddString(m_strKomunikat);
			// Odwieenie okna dialogowego
			UpdateData(FALSE);
		}
	}
}

void CGniazdaDlg::OnPzamknij() 
{
	// TODO: Add your control notification handler code here
	// Wywoanie funkcji OnClose
	OnClose();
}
