// ModArt.cpp: implementation of the CModArt class.
//
//////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <time.h>

#include "stdafx.h"
#include "Linia.h"
#include "ModArt.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CModArt::CModArt()
{
	// Inicjalizacja generatora liczb losowych
	srand((unsigned)time(NULL));
	// Inicjalizacja zmiennych waciwoci
	m_iDlugosc = 200;
	m_iSegmenty = 50;
}

CModArt::~CModArt()
{

}

void CModArt::UstawObszar(CRect rObszarRysowania)
{
	// Ustawienie obszaru rysowania
	m_rObszarRysowania = rObszarRysowania;
}

void CModArt::CzyscRysunek()
{
	// Pobranie iloci linii w tablicy obiektw
	int liLicznik = m_oaLinie.GetSize();
	int liPoz;

	// Czy w tablicy znajduj si jakiekolwiek obiekty?
	if (liLicznik)
	{
		// Ptla usuwajca wszystkie obiekty z tablicy
		for (liPoz = 0; liPoz < liLicznik; liPoz++)
			delete m_oaLinie[liPoz];
		// Zresetowanie tablicy
		m_oaLinie.RemoveAll();
	}
}

void CModArt::Rysuj(CDC *pDC)
{
	// Pobranie liczby linii w tablicy obiektw
	int liLicznik = m_oaLinie.GetSize();
	int liPoz;

	// Czy w tablicy znajduj si jakie obiekty?
	if (liLicznik)
	{
		// Rysowanie linii
		for (liPoz = 0; liPoz < liLicznik; liPoz++)
			((CLinia*)m_oaLinie[liPoz])->Rysuj(pDC);
	}
}

void CModArt::Serialize(CArchive &ar)
{
	// Przekazanie obiektu archiwum do tablicy obiektw
	m_oaLinie.Serialize(ar);
}

void CModArt::NowaLinia()
{
	int lLiczbaLini;
	int lBiezacaLinia;
	int nBiezacyKolor;
	UINT nBiezacaSzerokosc;
	CPoint pDo;
	CPoint pOd;
	int cCzerwony;
	int cNiebieski;
	int cZielony;

	// Normalizowanie obszaru przed okreleniem wysokoci i szerokoci
	m_rObszarRysowania.NormalizeRect();
	// pobranie szerokoci i wysokoi obszaru
	int lSzerokosc = m_rObszarRysowania.Width();
	int lWysokosc = m_rObszarRysowania.Height();

	COLORREF crKolory[8] = {
		RGB(   0,   0,   0),	// Czarny
		RGB(   0,   0, 255),	// Niebieski
		RGB(   0, 255,   0),	// Zielony
		RGB(   0, 255, 255),	// Bkitny
		RGB( 255,   0,   0),	// Czerwony
		RGB( 255,   0, 255),	// Fioletowy
		RGB( 255, 255,   0),	// ty
		RGB( 255, 255, 255)		// Biay
	};

	// Okrelenie liczby elementw skadajcych si na wstg
	lLiczbaLini = rand() % m_iSegmenty;
	// Czy ustalona liczba elementw jest wiksza od 0?
	if (lLiczbaLini > 0)
	{
		// Okrelenie koloru
		nBiezacyKolor = rand() % 8;
		cCzerwony = rand() % 255;
		cNiebieski = rand() % 255;
		cZielony = rand() % 255;
		// Okrelenie gruboci pira
		nBiezacaSzerokosc = (rand() % 8) + 1;
		// Okrelenie punktu startowego wstgi 
		pOd.x = (rand() % lSzerokosc) + m_rObszarRysowania.left;
		pOd.y = (rand() % lWysokosc) + m_rObszarRysowania.top;
		// Ptla wykonywana dla wszystkich segmentw linii
		for (lBiezacaLinia = 0; lBiezacaLinia < lLiczbaLini; lBiezacaLinia++)
		{
			// Okrelenie losowego punku kocowego segmentu
			pDo.x = ((rand() % 20) - 10) + pOd.x;
			pDo.y = ((rand() % 20) - 10) + pOd.y;
			// Utworzenie nowego obiektu linii
//			CLinia *pLinia = new CLinia(pOd, pDo, nBiezacaSzerokosc, crKolory[nBiezacyKolor]);
   		CLinia *pLinia = new CLinia(pOd, pDo, /*nBiezacaSzerokosc, */RGB(cCzerwony, cZielony, cNiebieski));
			try
			{
				// Dodanie nowego obiektu do tablicy
				m_oaLinie.Add(pLinia);
			}
			// Czy nastpi wyjtek pamici ?
			catch (CMemoryException* perr)
			{
				// Wywietlenie komunikatu dla uytkownika
				// z informacj o powstaym bdzie
				AfxMessageBox("Brak dostpnej pamici", MB_ICONSTOP | MB_OK);
				// Czy utworzony zosta obiekt linii?
				if (pLinia)
				{
					// Usunicie obiektu linii
					delete pLinia;
					pLinia = NULL;
				}
				// Usunicie obiektu wyjtku
				perr->Delete();
			}
			// Ustawienie punku startowego na punkt kocowy
			pOd = pDo;
		}
	}
}

void CModArt::NowyRysunek()
{
	int lLiczbaLini;
	int lBiezacaLinia;

	// Okrelenie ile linii bdzie generowanych
	lLiczbaLini = rand() % m_iSegmenty;
	// Czy liczba linii do utworzenia przekracza 0?
	if (lLiczbaLini > 0)
	{
		// Ptla wykonywana dla wszystkich linii
		for (lBiezacaLinia = 0; lBiezacaLinia < lLiczbaLini; lBiezacaLinia++)
		{
			// Utworzenie nowej linii
			NowaLinia();
		}
	}
}

int CModArt::PobierzDlugosc()
{
	// Zwrcenie biecej wartoci zmiennej m_iDlugosc
	return m_iDlugosc;
}


void CModArt::UstawDlugosc(int iDlugosc)
{
	// Ustawienie biecej wartoci zmiennej m_iDlugosc
	m_iDlugosc = iDlugosc;
}

int CModArt::PobierzSegmenty()
{
	// Zwrcenie biecej wartoci zmiennej m_iSegmenty
	return m_iSegmenty;
}

void CModArt::UstawSegmenty(int iSegmenty)
{
	// Ustawienie biecej wartoci zmiennej m_iSegmenty
	m_iSegmenty = iSegmenty;
}
