// DbOdbcView.cpp : implementation of the CDbOdbcView class
//

#include "stdafx.h"
#include "DbOdbc.h"

#include "DbOdbcSet.h"
#include "DbOdbcDoc.h"
#include "DbOdbcView.h"
#include "MoveToDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDbOdbcView

IMPLEMENT_DYNCREATE(CDbOdbcView, CRecordView)

BEGIN_MESSAGE_MAP(CDbOdbcView, CRecordView)
	//{{AFX_MSG_MAP(CDbOdbcView)
	ON_COMMAND(IDM_RECORD_NEW, OnRekordNowy)
	ON_COMMAND(IDM_RECORD_DELETE, OnUsunRekord)
	ON_COMMAND(IDM_RECORD_MOVE, OnRekordPrzejdz )
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CRecordView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRecordView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRecordView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDbOdbcView construction/destruction

CDbOdbcView::CDbOdbcView()
	: CRecordView(CDbOdbcView::IDD)
{
	//{{AFX_DATA_INIT(CDbOdbcView)
	m_pZbior = NULL;
	m_oledtDOB = COleDateTime::GetCurrentTime();
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CDbOdbcView::~CDbOdbcView()
{
}

void CDbOdbcView::DoDataExchange(CDataExchange* pDX)
{
	CRecordView::DoDataExchange(pDX);
	// Kopiowanie DUR ze zbioru rekordw do zmiennej widoku
	if (pDX->m_bSaveAndValidate == FALSE)
		m_oledtDOB = m_pZbior->m_DataUR;
	//{{AFX_DATA_MAP(CDbOdbcView)
	DDX_FieldText(pDX, IDC_EID, m_pZbior->m_AdresID, m_pZbior);
	DDX_FieldText(pDX, IDC_EFNAME, m_pZbior->m_Imi_, m_pZbior);
	DDX_FieldText(pDX, IDC_ELNAME, m_pZbior->m_Nazwisko, m_pZbior);
	DDX_FieldText(pDX, IDC_ESNAME, m_pZbior->m_Imi_Wsp__ma__onka, m_pZbior);
	DDX_FieldText(pDX, IDC_ESTATE, m_pZbior->m_StanLubProwincja, m_pZbior);
	DDX_FieldText(pDX, IDC_ECITY, m_pZbior->m_Miasto, m_pZbior);
	DDX_FieldText(pDX, IDC_EADDR, m_pZbior->m_Adres, m_pZbior);
	DDX_FieldCheck(pDX, IDC_CBCARD, m_pZbior->m_KartaWysy_ki, m_pZbior);
	DDX_FieldText(pDX, IDC_ECOUNTRY, m_pZbior->m_Kraj, m_pZbior);
	DDX_FieldText(pDX, IDC_EEMAIL, m_pZbior->m_AdresEmail, m_pZbior);
	DDX_FieldText(pDX, IDC_EFAX, m_pZbior->m_NrFaksu, m_pZbior);
	DDX_FieldText(pDX, IDC_EHPHONE, m_pZbior->m_TelefonDomowy, m_pZbior);
	DDX_FieldText(pDX, IDC_ENOTES, m_pZbior->m_Uwagi, m_pZbior);
	DDX_FieldText(pDX, IDC_EWEXT, m_pZbior->m_Wewn_trzny, m_pZbior);
	DDX_FieldText(pDX, IDC_EWPHONE, m_pZbior->m_TelDoPracy, m_pZbior);
	DDX_FieldText(pDX, IDC_EZIP, m_pZbior->m_KodPocztowy, m_pZbior);
	DDX_Text(pDX, IDC_EDOB, m_oledtDOB);
	//}}AFX_DATA_MAP
	// Copy the DOB variable back from the view variable to the record set
	if (pDX->m_bSaveAndValidate == TRUE)
		m_pZbior->m_DataUR = m_oledtDOB;
}

BOOL CDbOdbcView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CRecordView::PreCreateWindow(cs);
}

void CDbOdbcView::OnInitialUpdate()
{
	m_pZbior = &GetDocument()->m_DbOdbcSet;
	CRecordView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

}

/////////////////////////////////////////////////////////////////////////////
// CDbOdbcView printing

BOOL CDbOdbcView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CDbOdbcView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CDbOdbcView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CDbOdbcView diagnostics

#ifdef _DEBUG
void CDbOdbcView::AssertValid() const
{
	CRecordView::AssertValid();
}

void CDbOdbcView::Dump(CDumpContext& dc) const
{
	CRecordView::Dump(dc);
}

CDbOdbcDoc* CDbOdbcView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDbOdbcDoc)));
	return (CDbOdbcDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDbOdbcView database support
CRecordset* CDbOdbcView::OnGetRecordset()
{
	return m_pZbior;
}


/////////////////////////////////////////////////////////////////////////////
// CDbOdbcView message handlers

void CDbOdbcView::OnRekordNowy() 
{
	// TODO: Add your command handler code here
	// Pobranie wskanika do zbioru rekordw
	CRecordset* pSet = OnGetRecordset();
	// Upewnienie si e wszelkie wprowadzone zmiany
	// zostay zapisane
	if (pSet->CanUpdate() && !pSet->IsDeleted())
	{
		pSet->Edit();
		if (!UpdateData())
			return;

		pSet->Update();
	}
	// Pobranie identyfikatora dla nowego rekordu
	long m_lNewID = m_pZbior->PobierzMaxID() + 1;
	// Dodanie nowego rekordu
	m_pZbior->AddNew();
	// Ustawienie identyfikatora w nowym rekordzie
	m_pZbior->m_AdresID = m_lNewID;
	// Zapisanie nowego rekordu
	m_pZbior->Update();
	// Odwieenie zbioru rekordw
	m_pZbior->Requery();
	// Przejcie do nowego rekordu
	m_pZbior->MoveLast();
	// Uaktualnienie formularza 
	UpdateData(FALSE);
}

void CDbOdbcView::OnUsunRekord() 
{

	// TODO: Add your command handler code here
	// Upewnienie si, e uytkownik rzeczywicie chce usun ten rekord
	if (MessageBox("Jeste pewien, e chcesz usun ten rekord?",
		"Usuwanie rekordu", MB_YESNO | MB_ICONQUESTION) == IDYES)
	{
		// Usunicie rekordu
		m_pZbior->Delete();
		// Przejcie do poprzedniego rekordu
		m_pZbior->MovePrev();
		// Uaktualnienie formularza
		UpdateData(FALSE);
	}
}

void CDbOdbcView::OnRekordPrzejdz () 
{
	// TODO: Add your command handler code here
	// Utowrzenie obiektu okna (klasy CPrzejdzDoDlg)
	CPrzejdzDoDlg CPrzejdzDoDlg;
	// Pobranie iloci pozycji do przejcia
	if (CPrzejdzDoDlg.DoModal() == IDOK)
	{
		// Utworzenie wskanika do zbioru rekordw
		CRecordset* pSet = OnGetRecordset();
		// Upewnienie si e nie ma zalegych zmian do zapisania
		if (pSet->CanUpdate() && !pSet->IsDeleted())
		{
			pSet->Edit();
			if (!UpdateData())
				return;

			pSet->Update();
		}
		// Ustawienie nowej pozycji
		pSet->SetAbsolutePosition(CPrzejdzDoDlg.m_lRowNbr);
		// Uaktualnienie formularza
		UpdateData(FALSE);
	}
}
