// PasekView.cpp : implementation of the CPasekView class
//

#include "stdafx.h"
#include "Pasek.h"

#include "Linia.h"
#include "PasekDoc.h"
#include "PasekView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CPasekView

IMPLEMENT_DYNCREATE(CPasekView, CView)

BEGIN_MESSAGE_MAP(CPasekView, CView)
	//{{AFX_MSG_MAP(CPasekView)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPasekView construction/destruction

CPasekView::CPasekView()
{
	// TODO: add construction code here

}

CPasekView::~CPasekView()
{
}

BOOL CPasekView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CPasekView drawing

void CPasekView::OnDraw(CDC* pDC)
{
	CPasekDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
 	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Pobranie iloci linii w dokumencie
	int liLiczbaLini = pDoc->PobierzLiczbeLini();

	// Czy w dokumencie s jakiekolwiek linie?
	if (liLiczbaLini)
	{
		int liPoz;
		CLinia *lptLinia;

		// Ptla wykonywana dla wszystkich linii w dokumencie
		for (liPoz = 0; liPoz < liLiczbaLini; liPoz++)
		{
			// Pobranie punktw Od i Do dla kadej linii
			lptLinia = pDoc->PobierzLinie(liPoz);
			// Rysowanie linii
			lptLinia->Rysuj(pDC);
		}
	}

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

/////////////////////////////////////////////////////////////////////////////
// CPasekView printing

BOOL CPasekView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CPasekView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CPasekView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CPasekView diagnostics

#ifdef _DEBUG
void CPasekView::AssertValid() const
{
	CView::AssertValid();
}

void CPasekView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CPasekDoc* CPasekView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPasekDoc)));
	return (CPasekDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPasekView message handlers

void CPasekView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Przechwycenie myszy, tak aby adna inna aplikacja
	// nie moga z niej korzysta, kiedy opuci okno aplikacji
	SetCapture();
	// Zachowanie pozycji myszy
	m_ptOstatniaPoz = point;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CView::OnLButtonDown(nFlags, point);
}

void CPasekView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Czy mysz zostaa przechwycona?
	if (GetCapture() == this)
		// Jeeli tak, zwolni j, aby inne aplikacje mogy
		// z niej korzysta
		ReleaseCapture();

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CView::OnLButtonUp(nFlags, point);
}

void CPasekView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------
	
	// Sprawdzenie, czy lewy przycisk myszy jest przytrzymany
	if ((nFlags & MK_LBUTTON) == MK_LBUTTON)
	{
		// Czy zostaa przechwycona mysz?
		if (GetCapture() == this)
		{
			// Pobranie kontekstu urzdzenia
			CClientDC dc(this);

			// Dodanie linii do dokumentu
			CLinia *pLinia = GetDocument()->DodajLinie(m_ptOstatniaPoz, point);

			// Rysowanie aktualnej linii
			pLinia->Rysuj(&dc);

			// Zapisanie aktualnej pozycji jako poprzedniej
			m_ptOstatniaPoz = point;
		}
	}

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CView::OnMouseMove(nFlags, point);
}

void CPasekView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CMenu *m_lMenu;
	CPoint m_pPunkt;

	m_pPunkt = point;
	ClientToScreen(&m_pPunkt);
	m_lMenu = GetMenu();
	if (m_lMenu)
	{
	//m_lMenu = m_lMenu->GetSubMenu(0);
	m_lMenu->TrackPopupMenu(TPM_CENTERALIGN + TPM_LEFTBUTTON, 
		m_pPunkt.x, m_pPunkt.y, this, NULL);
	}
	CView::OnRButtonDown(nFlags, point);
}
