// PasekDoc.cpp : implementation of the CPasekDoc class
//

#include "stdafx.h"
#include "Pasek.h"
#include "MainFrm.h"
#include "Linia.h"
#include "PasekDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPasekDoc

IMPLEMENT_DYNCREATE(CPasekDoc, CDocument)

BEGIN_MESSAGE_MAP(CPasekDoc, CDocument)
	ON_UPDATE_COMMAND_UI(ID_INDYKATOR_KOLOR, OnUpdateIndykatorKolor)
	//{{AFX_MSG_MAP(CPasekDoc)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_VTHIN, OnUpdateSzerokoscBCienki)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_VTHICK, OnUpdateSzerokoscBGruby)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_THIN, OnUpdateSzerokoscCienki)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_THICK, OnUpdateSzerokoscGruby)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_MEDIUM, OnUpdateSzerokoscSredni)
	ON_UPDATE_COMMAND_UI(ID_COLOR_YELLOW, OnUpdateColorYellow)
	ON_UPDATE_COMMAND_UI(ID_COLOR_WHITE, OnUpdateColorWhite)
	ON_UPDATE_COMMAND_UI(ID_COLOR_RED, OnUpdateColorRed)
	ON_UPDATE_COMMAND_UI(ID_COLOR_MAGENTA, OnUpdateColorMagenta)
	ON_UPDATE_COMMAND_UI(ID_COLOR_GREEN, OnUpdateColorGreen)
	ON_UPDATE_COMMAND_UI(ID_COLOR_CYAN, OnUpdateColorCyan)
	ON_UPDATE_COMMAND_UI(ID_COLOR_BLUE, OnUpdateColorBlue)
	ON_UPDATE_COMMAND_UI(ID_COLOR_BLACK, OnUpdateColorBlack)
	ON_COMMAND(ID_COLOR_BLACK, OnColorBlack)
	ON_COMMAND(ID_COLOR_BLUE, OnColorBlue)
	ON_COMMAND(ID_COLOR_CYAN, OnColorCyan)
	ON_COMMAND(ID_COLOR_GREEN, OnColorGreen)
	ON_COMMAND(ID_COLOR_MAGENTA, OnColorMagenta)
	ON_COMMAND(ID_COLOR_RED, OnColorRed)
	ON_COMMAND(ID_COLOR_WHITE, OnColorWhite)
	ON_COMMAND(ID_COLOR_YELLOW, OnColorYellow)
	ON_COMMAND(ID_WIDTH_MEDIUM, OnSzerokoscSredni)
	ON_COMMAND(ID_WIDTH_THICK, OnSzerokoscGruby)
	ON_COMMAND(ID_WIDTH_THIN, OnSzerokoscCienki)
	ON_COMMAND(ID_WIDTH_VTHICK, OnSzerokoscBGruby)
	ON_COMMAND(ID_WIDTH_VTHIN, OnSzerokoscBCienki)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

const COLORREF CPasekDoc::m_crKolory[8] = {
	RGB(   0,   0,   0),	// Czarny
	RGB(   0,   0, 255),	// Niebieski
	RGB(   0, 255,   0),	// Zielony
	RGB(   0, 255, 255),	// Bkitny
	RGB( 255,   0,   0),	// Czerwony
	RGB( 255,   0, 255),	// Fioletowy
	RGB( 255, 255,   0),	// ty
	RGB( 255, 255, 255)		// Biay
};

/////////////////////////////////////////////////////////////////////////////
// CPasekDoc construction/destruction

CPasekDoc::CPasekDoc()
{
	// TODO: add one-time construction code here

}

CPasekDoc::~CPasekDoc()
{
}

BOOL CPasekDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (PASEK documents will reuse this document)

	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Inicjalizacja koloru na czarny
	m_nKolor = ID_COLOR_BLACK - ID_COLOR_BLACK;
	m_nSzerokosc = ID_WIDTH_MEDIUM - ID_WIDTH_VTHIN;
	UaktualnijPasek(m_nSzerokosc);

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CPasekDoc serialization

void CPasekDoc::Serialize(CArchive& ar)
{
	// Przekazanie serializacji do tablicy obiektw
	m_oaLinie.Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CPasekDoc diagnostics

#ifdef _DEBUG
void CPasekDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CPasekDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPasekDoc commands

int CPasekDoc::PobierzLiczbeLini()
{
	// Zwrcenie liczby elementw w tablicy
	return m_oaLinie.GetSize();
}

CPoint* CPasekDoc::PobierzDo(int nIndex)
{

	// Zwrcenie wskanika do punktu "Do" znajdujcego
	// w obiekcie CLinia na okrelonej pozycji w tablicy
	// obiektw 
	return ((CLinia*)m_oaLinie[nIndex])->PobierzDo();
}

CPoint* CPasekDoc::PobierzOd(int nIndex)
{
	// Zwrcenie wskanika do punktu "Od" znajdujcego
	// w obiekcie CLinia na okrelonej pozycji w tablicy
	// obiektw 
	return ((CLinia*)m_oaLinie[nIndex])->PobierzOd();
}

CLinia * CPasekDoc::DodajLinie(CPoint ptOd, CPoint ptDo)
{
	static UINT nSzerokosci[5] = { 1, 8, 16, 24, 32};

	// Utworzenie nowego obiektu klasy CLinia
	CLinia *pLinia = new CLinia(ptOd, ptDo, nSzerokosci[m_nSzerokosc], m_crKolory[m_nKolor]);
	try
	{
		// Dodanie nowego obiektu do tablicy
		m_oaLinie.Add(pLinia);
		// Zaznaczenie dokumentu jako "brudnego"
		SetModifiedFlag();
	}
	// Czy wystpi wyjtek pamici?
	catch (CMemoryException* perr)
	{
		// Poinformowanie uytkownika o wystpieniu wyjtku
		// pamici
		AfxMessageBox("Brak wolnej pamici", MB_ICONSTOP | MB_OK);
		// Czy zosta utworzony obiekt linii?
		if (pLinia)
		{
			// Usunicie obiektu linii
			delete pLinia;
			pLinia = NULL;
		}
		// Usunicie obiektu wyjtku
		perr->Delete();
	}
	return pLinia;
}

void CPasekDoc::DeleteContents() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Pobranie liczby linii w tablicy obiektw
	int liLiczbaLinii = m_oaLinie.GetSize();
	int iPoz;

	// Czy w tablicy znajduj si jakiekolwiek linie?
	if (liLiczbaLinii)
	{
		// Ptla usuwajca wszystkie obiekty z tablicy
		for (iPoz = 0; iPoz < liLiczbaLinii; iPoz++)
			delete m_oaLinie[iPoz];
		// Wyzerowanie tablicy
		m_oaLinie.RemoveAll();
	}

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CDocument::DeleteContents();
}

CLinia * CPasekDoc::PobierzLinie(int nIndex)
{
	// Zwrcenie wskanika do obiektu linii znajdujcego
	// si w okrelonym miejscu w tablicy obiektw
	return (CLinia*)m_oaLinie[nIndex];
}

UINT CPasekDoc::PobierzKolor()
{
	// Zwrcenie wartoci aktualnego koloru
	return ID_COLOR_BLACK + m_nKolor;
}

UINT CPasekDoc::PobierzSzerokosc()
{
	// Zwrcenie biecej grubosci pira
	return ID_WIDTH_VTHIN + m_nSzerokosc;
}

void CPasekDoc::OnUpdateSzerokoscBCienki(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_VTHIN ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_VTHIN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateSzerokoscBGruby(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_VTHICK ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_VTHICK ? 1 : 0);

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateSzerokoscCienki(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_THIN ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_THIN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateSzerokoscGruby(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_THICK ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_THICK ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateSzerokoscSredni(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_MEDIUM ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_MEDIUM ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorYellow(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_YELLOW ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_YELLOW ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorWhite(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_WHITE ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_WHITE ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorRed(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_RED ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_RED ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorMagenta(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_MAGENTA ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_MAGENTA ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorGreen(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_GREEN ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_GREEN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorCyan(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_CYAN ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_CYAN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorBlue(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_BLUE ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_BLUE ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnUpdateColorBlack(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_BLACK ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_BLACK ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorBlack() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na czarny
	m_nKolor = 0;	

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorBlue() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na niebieski
	m_nKolor = 1;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorCyan() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na bkitny
	m_nKolor = 3;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorGreen() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na zielony
	m_nKolor = 2;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorMagenta() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na fioletowy
	m_nKolor = 5;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorRed() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na czerwony
	m_nKolor = 4;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorWhite() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na biay
	m_nKolor = 7;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnColorYellow() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na ty
	m_nKolor = 6;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnSzerokoscSredni() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na redni
	m_nSzerokosc = 2;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(2);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnSzerokoscGruby() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na grub
	m_nSzerokosc = 3;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(3);

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnSzerokoscCienki() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na ciank
	m_nSzerokosc = 1;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(1);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnSzerokoscBGruby() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na bardzo grub
	m_nSzerokosc = 4;

	// Uaktualnienie paska kolorw
	UaktualnijPasek(4);

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::OnSzerokoscBCienki() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na bardzo cienk
	m_nSzerokosc = 0;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CPasekDoc::UstawSzerokosc(int nIndex)
{
	// Ustawienie biecej gruboci
	m_nSzerokosc = nIndex;
}


void CPasekDoc::UaktualnijPasek(int nIndex)
{
	// Pobranie pozycji pierwszego widoku
	POSITION poz = GetFirstViewPosition();
	// Czy pobrana zostaa prawidowa pozycja?
	if (poz != NULL)
	{
		// Utworzenie wskanika do widoku na tej pozycji
		CView* pView = GetNextView(poz);
		// Czy utworzone zostao prawidowe wskazanie?
		if (pView)
		{
			// Pobranie wkazania do ramki poprzez widok
			CMainFrame* pFrame = (CMainFrame*)pView->GetTopLevelFrame();
			// Sprawdzenie czy wskazanie jest poprawne
			if (pFrame)
				// Uaktualnienie obiektu kombi poprzez ramk
				pFrame->UaktualnijGruboscCB(nIndex);
		}
	}
}

void CPasekDoc::OnUpdateIndykatorKolor(CCmdUI *pCmdUI)
{
	CString strColor;

	switch (m_nKolor)
	{
	case 0:
		strColor = "CZARNY";
		break;
	case 1:
		strColor = "NIEBIESKI";
		break;
	case 2:
		strColor = "ZIELONY";
		break;
	case 3:
		strColor = "BKITNY";
		break;
	case 4:
		strColor = "CZERWONY";
		break;
	case 5:
		strColor = "FIOLETOWY";
		break;
	case 6:
		strColor = "ӣTY";
		break;
	case 7:
		strColor = "BIAY";
		break;
	}
	pCmdUI->Enable(TRUE);
	pCmdUI->SetText(strColor);
}
