// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Sdi.h"

#include "Linia.h"
#include "SdiDoc.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_PASEKKOLOROW, OnViewPasekkolorow)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PASEKKOLOROW, OnUpdateViewPasekkolorow)
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(IDC_CBGRUBOSC, OnSelChangeSzerokosc)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDYKATOR_KOLOR,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Prba utworzenia paska nie udaa si \n");
		return -1;      // Nie utworzono paska
	}

	// Dodanie paska kolorw
	UtworzPasekKolorow();


	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Prba utworzenia paska nie powioda si\n");
		return -1;      // Nie utworzono paska
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	// Udostpnienie dokowania dla paska kolorw
	m_wndPasekKoloru.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);
	// Zadokowanie paka kolorw
	DockControlBar(&m_wndPasekKoloru);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers



BOOL CMainFrame::UtworzPasekKolorow()
{
	int iTBCtlID;
	int i;

	if (!m_wndPasekKoloru.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndPasekKoloru.LoadToolBar(IDR_TBCOLOR))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	iTBCtlID = m_wndPasekKoloru.CommandToIndex(ID_COLOR_BLACK);
	if (iTBCtlID >= 0)
	{
		for (i= iTBCtlID; i < (iTBCtlID + 8); i++)
			m_wndPasekKoloru.SetButtonStyle(i, TBBS_CHECKGROUP);
	}
	// Dodanie obiektu kombi
	int nSzerokosc = 100;
	int nHeight = 125;

	// Konfigurowanie wskanika pooenia obiektu kombi
	m_wndPasekKoloru.SetButtonInfo(9, IDC_CBGRUBOSC, TBBS_SEPARATOR, nSzerokosc);

	// Pobranie wysokoci paska kolorw 
	CRect rect;
	m_wndPasekKoloru.GetItemRect(9, &rect);
	rect.bottom = rect.top + nHeight;
	
	// Utworzenie obiektu kombi
	m_ctlGrubosc.Create(WS_CHILD | WS_VISIBLE | WS_VSCROLL |
		CBS_DROPDOWNLIST, rect, &m_wndPasekKoloru, IDC_CBGRUBOSC);

	//  Wypenienie obiektu kombi
	CString szStyle;
	if (szStyle.LoadString(IDS_GRUBOSC_BCIENKIE))
		m_ctlGrubosc.AddString((LPCTSTR)szStyle);
	if (szStyle.LoadString(IDS_GRUBOSC_CIENKIE))
		m_ctlGrubosc.AddString((LPCTSTR)szStyle);
	if (szStyle.LoadString(IDS_GRUBOSC_SREDNIE))
		m_ctlGrubosc.AddString((LPCTSTR)szStyle);
	if (szStyle.LoadString(IDS_GRUBOSC_GRUBE))
		m_ctlGrubosc.AddString((LPCTSTR)szStyle);
	if (szStyle.LoadString(IDS_GRUBOSC_BGRUBE))
		m_ctlGrubosc.AddString((LPCTSTR)szStyle);

	return TRUE;
}

void CMainFrame::OnSelChangeSzerokosc()
{
	// Pobranie aktywnej pozycji w obiekcie kombi
	int nIndex = m_ctlGrubosc.GetCurSel();
	if (nIndex == CB_ERR)
		return;
	
	// Pobranie biecego dokumentu
	CSdiDoc* pDoc = (CSdiDoc*)GetActiveDocument();
	// Czy pobrane zostao prawidowe wskazanie do dokumentu?
	if (pDoc)
		// Ustawienie nowej gruboci rysowania
		pDoc->UstawSzerokosc(nIndex);
}

void CMainFrame::UaktualnijGruboscCB(int nIndex)
{
	// Ustawienie nowego wyboru z obiektu kombi
	m_ctlGrubosc.SetCurSel(nIndex);
}

void CMainFrame::OnViewPasekkolorow() 
{
	// TODO: Add your command handler code here
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------
	BOOL bWidoczny;

	// Sprawdzenie stanu paska koloru
	bWidoczny = ((m_wndPasekKoloru.GetStyle() & WS_VISIBLE) != 0);

	// Ukrycie paska koloru
	ShowControlBar(&m_wndPasekKoloru, !bWidoczny, FALSE);
	// Odwieenie ukadu strony
	RecalcLayout();

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------
}

void CMainFrame::OnUpdateViewPasekkolorow(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie stanu paska narzdzi
	pCmdUI->SetCheck(((m_wndPasekKoloru.GetStyle() & WS_VISIBLE) != 0));	

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------

}
