// ZadaniaDoc.cpp : implementation of the CZadaniaDoc class
//

#include "stdafx.h"
#include "Zadania.h"

#include "WirujaceKolo.h"
#include "ZadaniaDoc.h"
#include "ZadaniaView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CZadaniaDoc

IMPLEMENT_DYNCREATE(CZadaniaDoc, CDocument)

BEGIN_MESSAGE_MAP(CZadaniaDoc, CDocument)
	//{{AFX_MSG_MAP(CZadaniaDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZadaniaDoc construction/destruction

CZadaniaDoc::CZadaniaDoc()
{
	// TODO: add one-time construction code here

}

CZadaniaDoc::~CZadaniaDoc()
{
}

BOOL CZadaniaDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Inicjalizacja obiektw wirujcych k
	InicjalizujKola();

	// Inicjalizacja wskanikw do wtkw
	m_pWirWatek[0] = NULL;
	m_pWirWatek[1] = NULL;

	//----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//----------------------------------------

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CZadaniaDoc serialization

void CZadaniaDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CZadaniaDoc diagnostics

#ifdef _DEBUG
void CZadaniaDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CZadaniaDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CZadaniaDoc commands

void CZadaniaDoc::WyznaczPkt(int nID, CWirujaceKolo *pKolo)
{
	RECT lObszarOkna;
	CPoint pPoz;
	int lDlugosc;
	CZadaniaView *pWnd;

	// Pobierz wskanik do okna widoku
	pWnd = (CZadaniaView*)pKolo->PobierzWskWidoku();
	// Pobierz obszar wywietlania
	pWnd->GetClientRect(&lObszarOkna);
	// Oblicz wielko obiektw wirujych k
	lDlugosc = lObszarOkna.right / 10;
	// Ktry obiekt jest przetwarzany?
	switch (nID)
	{
	case 0:	// Pozycja pierwszego obiektu
		pPoz.x = (lObszarOkna.right / 4) - lDlugosc;
		pPoz.y = (lObszarOkna.bottom / 4) - lDlugosc;
		break;
	case 1:	// Pozycja drugiego obiektu
		pPoz.x = ((lObszarOkna.right / 4) * 3) - lDlugosc;
		pPoz.y = (lObszarOkna.bottom / 4) - lDlugosc;
		break;
	case 2:	// Pozycja trzeciego obiektu
		pPoz.x = (lObszarOkna.right / 4) - lDlugosc;
		pPoz.y = ((lObszarOkna.bottom / 4) * 3) - (long)(lDlugosc * 1.25);
		break;
	case 3:	// Pozycja czwartego obiektu
		pPoz.x = ((lObszarOkna.right / 4) * 3) - lDlugosc;
		pPoz.y = ((lObszarOkna.bottom / 4) * 3) - (long)(lDlugosc * 1.25);
		break;
	}
	// Ustawienie rozmiaru obiektu wirujcego ko
	pKolo->UstawDlugosc(lDlugosc);
	// Ustawienie lokalizacji obiektu
	pKolo->UstawPunkt(pPoz);
}

void CZadaniaDoc::InicjalizujKola()
{
	int i;

	// Pobranie pozycji widoku
	POSITION pos = GetFirstViewPosition();
	// Sprawdzenie poprawnoci otrzymanego wskanika
	if (pos != NULL)
	{
		// Utworzenie wskanika do widoku o znanej pozycji
		CView* pView = GetNextView(pos);

		// Ptala wykonywana dla wszystkich obiektw wirujcych k
		for (i = 0; i < 4; i++)
		{
			// Ustawienie wskanika do widoku danego obiektu
			m_cKolo[i].UstawWskWidoku(pView);
			// Inicjalizacja wskanika do znacznika kontyunacji obiektu
			m_cKolo[i].UstawKontynuuj(NULL);
			switch (i)
			{
			case 1:	// Ustaw wskanik do pierwszego znacznika kontynujacji wtku
				m_cKolo[i].UstawKontynuuj(&((CZadaniaView*)pView)->m_bWatek1);
				break;
			case 3:	// Ustaw wskanik do trzeciego znacznika kontynujacji wtku
				m_cKolo[i].UstawKontynuuj(&((CZadaniaView*)pView)->m_bWatek2);
				break;
			}
			// Obliczenie pooenia i-tego obiektu wirujcego koa
			WyznaczPkt(i, &m_cKolo[i]);
		}
	}
}

void CZadaniaDoc::OdswiezKolo(int nIndex)
{
	// Rysuj wirujce koo
	m_cKolo[nIndex].Rysuj();
}

UINT CZadaniaDoc::FunkacjaWatka(LPVOID pParam)
{
	
	// Konwersja argumentu na wskanik do obiektu wierujceg koa
	// dla tego wtku
	CWirujaceKolo* lpWirujaceKolo = (CWirujaceKolo*)pParam;
	// Utworzenie wskanika do znacznika kontynuacji
	BOOL* pbKontynuuj = lpWirujaceKolo->PobierzKontynuuj();

	// Ptla trwajca tak dugo jak dugo znacznik kontynuacji ma wart. TRUE
	while (TRUE) //(*pbKontynuuj)
		// Odwieanie obiektu wirujcego ko
		lpWirujaceKolo->Rysuj();
	return 0;
}

void CZadaniaDoc::ZawiesWatek(int nIndex, BOOL bZawies)
{
	// Jeeli wtek jest zawieszony
	if (!bZawies)
	{
		// Sprawdzenie poprawnoci wskanika do wtku
		if (m_pWirWatek[nIndex])
		{
			// Zawieszenie pracy wtku
			m_pWirWatek[nIndex]->SuspendThread();
			// Utworzenie uchwytu do wtku
//			HANDLE hThread = m_pWirWatek[nIndex]->m_hThread;
			// Oczekiwanie na zakoczenie pracy wtku
//			::WaitForSingleObject (hThread, INFINITE);
		}
	}
	else	// Aktywowanie wtku
	{
		// Sprawdzenie poprawnoci wskanika do wtku
		if (m_pWirWatek[nIndex])
		{
			// Wznowienie pracy wtku
			m_pWirWatek[nIndex]->ResumeThread();
		}
		else
		{
		int iObiektKola;
		int iPriorytet;
		// Ktry watek ma by uyty?
		switch (nIndex)
		{
		case 0:
			iObiektKola = 1;
			iPriorytet = THREAD_PRIORITY_NORMAL;
			break;
		case 1:
			iObiektKola = 3;
			iPriorytet = THREAD_PRIORITY_LOWEST;
			break;
		}
		// Rozpoczcie wtku, przekazanie mu wakanika do obiektu kola
		m_pWirWatek[nIndex] = AfxBeginThread(FunkacjaWatka, 
			(LPVOID)&m_cKolo[iObiektKola], iPriorytet);
		}
	}
}
