// WirujaceKolo.cpp: implementation of the CWirujoceKolo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <math.h>
#include "Zadania.h"
#include "WirujaceKolo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

COLORREF CWirujaceKolo::m_crKolory[8] = {
	RGB(   0,   0,   0),	// Czarny
	RGB(   0,   0, 255),	// Niebieski
	RGB(   0, 255,   0),	// Zielony
	RGB(   0, 255, 255),	// Bkitny
	RGB( 255,   0,   0),	// Czerwony
	RGB( 255,   0, 255),	// Fioletowy
	RGB( 255, 255,   0),	// ty
	RGB( 255, 255, 255)		// Biay
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CWirujaceKolo::CWirujaceKolo()
{
	// Inicjalizacja pozycji, rozmiaru i koloru
	m_iPromien = 0;
	m_nMinuta = 0;
	m_crKolor = 0;
	// Ustawienie wskanikw na adres pusty
	m_pWidok = NULL;
	m_bKontynuuj = NULL;
}

CWirujaceKolo::~CWirujaceKolo()
{

}

void CWirujaceKolo::Rysuj()
{
	// Utworzenie wskanika do kontekstu urzdzenia
	CDC *pDC = m_pWidok->GetDC();
	// Ustawienie trybu mapowania
	pDC->SetMapMode (MM_LOENGLISH);
	// Skopiowanie punktu rodka okrgu
	CPoint org = m_pSrodek;
	CPoint pPunktStartowy;
	// Ustawienie punktu pocztkowego
	pPunktStartowy.x = (m_iPromien / 2);
	pPunktStartowy.y = (m_iPromien / 2);
	// Wyznaczenie punktu pocztkowego dla portu widoku
	org.x = m_pSrodek.x + (m_iPromien / 2);
	org.y = m_pSrodek.y + m_iPromien;
	// Ustawienie punktu pocztkowego portu widoku
	pDC->SetViewportOrg(org.x, org.y);

	CPoint pPunktKoncowy;
	// Przeliczenie pozycji ktkowej nastpnej linii
	double nRadiany = (double) (m_nMinuta * 6) * 0.017453292;
	// Ustawienie punktu kocowego linii
	pPunktKoncowy.x = (int) ((m_iPromien * sin(nRadiany)));
	pPunktKoncowy.y = (int) ((m_iPromien * cos(nRadiany)));


	// Utworzenie pira do uytku
	CPen pioro(PS_SOLID, 0, m_crKolory[m_crKolor]);
	// Wybranie pira do uytku
	CPen* pStarePioro = pDC->SelectObject(&pioro);

	// Przejcie do punktu startowego
	pDC->MoveTo (pPunktStartowy);
	// Rysowanie linii do punktu kocowego
	pDC->LineTo (pPunktKoncowy);

	// Przywrcenie pierwotnego pira
	pDC->SelectObject(&pStarePioro);

	// Zwolnienie kontekstu urzdzenia
	m_pWidok->ReleaseDC(pDC);

	// Zwikszenie wartoci minutowej
	if (++m_nMinuta == 60)
	{
		// Jeeli warto minutowa osignie wart. 60 nastpi wyzerowanie
		m_nMinuta = 0;
		// Increment the color
		// Zwikszenie wartoci koloru
		if (++m_crKolor == 8)
			// Po przejciu przez wszystkie kolory, rozpoczcie od nowa
			m_crKolor = 0;
	}
}

void CWirujaceKolo::UstawPunkt(CPoint pPunkt)
{
	// Ustawienie pozycji wyirujcego koa
	m_pSrodek = pPunkt;
}

void CWirujaceKolo::UstawDlugosc(int iDlugosc)
{
	// Ustawienie rozmiaru obiektu wirujcego koa
	m_iPromien = iDlugosc;
}

void CWirujaceKolo::UstawWskWidoku(CWnd *pWnd)
{
	// Ustawienie wskanika do obiektu widoku
	m_pWidok = pWnd;
}


void CWirujaceKolo::UstawKontynuuj(BOOL *bKontynuuj)
{
	// Ustawienie wskanika do znacznika kontynuacji
	m_bKontynuuj = bKontynuuj;
}

