// DbAdoView.cpp : implementation of the CDbAdoView class
//

#include "stdafx.h"
#include "DbAdo.h"

#include "CustomRS.h"
#include "DbAdoDoc.h"
#include "DbAdoView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDbAdoView

IMPLEMENT_DYNCREATE(CDbAdoView, CFormView)

BEGIN_MESSAGE_MAP(CDbAdoView, CFormView)
	//{{AFX_MSG_MAP(CDbAdoView)
	ON_COMMAND(IDM_DATA_FIRST, OnRekordPierwszy)
	ON_COMMAND(IDM_DATA_LAST, OnRekordOstatni)
	ON_COMMAND(IDM_DATA_NEXT, OnRekordNastepny)
	ON_COMMAND(IDM_DATA_PREV, OnRekordPoprzedni)
	ON_COMMAND(IDM_DATA_NEW, OnDataNew)
	ON_COMMAND(IDM_DATA_DELETE, OnDataDelete)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDbAdoView construction/destruction

CDbAdoView::CDbAdoView()
	: CFormView(CDbAdoView::IDD)
{
	//{{AFX_DATA_INIT(CDbAdoView)
	m_lAdresID = 0;
	m_strImie = _T("");
	m_strNazwisko = _T("");
	m_strImieMalzonka = _T("");
	m_strAdres = _T("");
	m_strMiasto = _T("");
	m_strStanlubProwincja = _T("");
	m_strKodPocztowy = _T("");
	m_strKraj = _T("");
	m_strAdresEmail = _T("");
	m_strTelefonDomowy = _T("");
	m_strTelSluzbowy = _T("");
	m_strWewnetrzny = _T("");
	m_strNumerFaksu = _T("");
	m_oledtDataUR = COleDateTime::GetCurrentTime();
	m_bKartaWysylki = FALSE;
	m_strUwagi = _T("");
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CDbAdoView::~CDbAdoView()
{
}

void CDbAdoView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDbAdoView)
	DDX_Text(pDX, IDC_EDIT_ADDRESSID, m_lAdresID);
	DDX_Text(pDX, IDC_EDIT_FIRSTNAME, m_strImie);
	DDX_Text(pDX, IDC_EDIT_LASTNAME, m_strNazwisko);
	DDX_Text(pDX, IDC_EDIT_SPOUSENAME, m_strImieMalzonka);
	DDX_Text(pDX, IDC_EDIT_ADDRESS, m_strAdres);
	DDX_Text(pDX, IDC_EDIT_CITY, m_strMiasto);
	DDX_Text(pDX, IDC_EDIT_STATEORPROVINCE, m_strStanlubProwincja);
	DDX_Text(pDX, IDC_EDIT_POSTALCODE, m_strKodPocztowy);
	DDX_Text(pDX, IDC_EDIT_COUNTRY, m_strKraj);
	DDX_Text(pDX, IDC_EDIT_EMAILADDRESS, m_strAdresEmail);
	DDX_Text(pDX, IDC_EDIT_HOMEPHONE, m_strTelefonDomowy);
	DDX_Text(pDX, IDC_EDIT_WORKPHONE, m_strTelSluzbowy);
	DDX_Text(pDX, IDC_EDIT_WORKEXTENSION, m_strWewnetrzny);
	DDX_Text(pDX, IDC_EDIT_FAXNUMBER, m_strNumerFaksu);
	DDX_Text(pDX, IDC_EDIT_BIRTHDATE, m_oledtDataUR);
	DDX_Check(pDX, IDC_CHECK_SENDCARD, m_bKartaWysylki);
	DDX_Text(pDX, IDC_EDIT_NOTES, m_strUwagi);
	//}}AFX_DATA_MAP
}

BOOL CDbAdoView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CDbAdoView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

}

/////////////////////////////////////////////////////////////////////////////
// CDbAdoView printing

BOOL CDbAdoView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CDbAdoView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CDbAdoView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CDbAdoView::OnPrint(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add customized printing code here
}

/////////////////////////////////////////////////////////////////////////////
// CDbAdoView diagnostics

#ifdef _DEBUG
void CDbAdoView::AssertValid() const
{
	CFormView::AssertValid();
}

void CDbAdoView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CDbAdoDoc* CDbAdoView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDbAdoDoc)));
	return (CDbAdoDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDbAdoView message handlers

void CDbAdoView::OnRekordPierwszy() 
{
	// TODO: Add your command handler code here
	// Uaktualnienie biecego rekordu
	UaktualnijDolaczoneDane();
	// Przejcie do pierwszego rekordu
	GetDocument()->PrzejdzPierwszy();
	// Odwieenie fomularza danymi nowego rekordu
	OdswiezDolaczoneDane();
}

void CDbAdoView::OnRekordOstatni() 
{
	// TODO: Add your command handler code here
	// Uaktualnienie biecego rekordu
	UaktualnijDolaczoneDane();
	// Przejcie do ostatniego rekordu
	GetDocument()->PrzejdzOstatni();
	// Odwieenie fomularza danymi nowego rekordu
	OdswiezDolaczoneDane();
}

void CDbAdoView::OnRekordNastepny() 
{
	// TODO: Add your command handler code here
	// Uaktualnienie biecego rekordu
	UaktualnijDolaczoneDane();
	// Przejcie do nastpnego rekordu
	GetDocument()->PrzejdzNastepny();
	// Odwieenie fomularza danymi nowego rekordu
	OdswiezDolaczoneDane();
}

void CDbAdoView::OnRekordPoprzedni() 
{
	// TODO: Add your command handler code here
	// Uaktualnienie biecego rekordu
	UaktualnijDolaczoneDane();
	// Przejcie do nastpnego rekordu
	GetDocument()->PrzejdzPoprzedni();
	// Odwieenie fomularza danymi nowego rekordu
	OdswiezDolaczoneDane();
}

void CDbAdoView::OdswiezDolaczoneDane()
{
	CCustomRs* pRs;

	// Pobranie wskanika do dokumentu
	pRs = GetDocument()->GetRecSet();

	// Czy pole jest prawidowe
	if (adFldOK == pRs->lAdresIDStan)
		// Kopiowanie wartosci
		m_lAdresID = pRs->m_lAdresID;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_lAdresID = 0;
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lImieStan)
		// Kopiowanie wartosci
		m_strImie = pRs->m_szImie;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strImie = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lNazwiskoStan)
		// Kopiowanie wartosci
		m_strNazwisko = pRs->m_szNazwisko;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strNazwisko = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lImieMalzonkaStan)
		// Kopiowanie wartosci
		m_strImieMalzonka = pRs->m_szImieMalzonka;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strImieMalzonka = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lAdresStan)
		// Kopiowanie wartosci
		m_strAdres = pRs->m_szAdres;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strAdres = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lMiastoStan)
		// Kopiowanie wartosci
		m_strMiasto = pRs->m_szMiasto;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strMiasto = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lStanlubProwincjaStan)
		// Kopiowanie wartosci
		m_strStanlubProwincja = pRs->m_szStanlubProwincja;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strStanlubProwincja = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lKodPocztowyStan)
		// Kopiowanie wartosci
		m_strKodPocztowy = pRs->m_szKodPocztowy;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strKodPocztowy = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lKrajStan)
		// Kopiowanie wartosci
		m_strKraj = pRs->m_szKraj;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strKraj = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lAdresEmailStan)
		// Kopiowanie wartosci
		m_strAdresEmail = pRs->m_szAdresEmail;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strAdresEmail = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lTelefonDomowyStan)
		// Kopiowanie wartosci
		m_strTelefonDomowy = pRs->m_szTelefonDomowy;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strTelefonDomowy = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lTelSluzbowyStan)
		// Kopiowanie wartosci
		m_strTelSluzbowy = pRs->m_szTelSluzbowy;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strTelSluzbowy = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lTelSluzbowyStan)
		// Kopiowanie wartosci
		m_strWewnetrzny = pRs->m_szWewnetrzny;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strWewnetrzny = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lNumerFaksuStan)
		// Kopiowanie wartosci
		m_strNumerFaksu = pRs->m_szNumerFaksu;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strNumerFaksu = _T("");
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lDataURStan)
		// Kopiowanie wartosci
		m_oledtDataUR = pRs->m_dtDataUR;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_oledtDataUR = 0L;
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lKartaWysylkiStan)
		// Kopiowanie wartosci
		m_bKartaWysylki = VARIANT_FALSE == pRs->m_bKartaWysylki ? FALSE : TRUE;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_bKartaWysylki = FALSE;
	// Czy pole jest prawidowe
	if (adFldOK == pRs->lUwagiStan)
		// Kopiowanie wartosci
		m_strUwagi = pRs->m_szUwagi;
	else
		// W przeciwnym wypadku ustaw warto na 0
		m_strUwagi = _T("");

	// Synchronizowanie danych z obiektami kontrolnymi
	UpdateData(FALSE);
}

void CDbAdoView::UaktualnijDolaczoneDane()
{
	CCustomRs* pRs;

	// Pobranie wskanika do dokumentu
	pRs = GetDocument()->GetRecSet();

	// Synchronizowanie zmiennych z obiektami kontrolnymi
	UpdateData(TRUE);

	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_lAdresID != pRs->m_lAdresID)
		pRs->m_lAdresID = m_lAdresID;
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strImie != pRs->m_szImie)
		strcpy(pRs->m_szImie, (LPCTSTR)m_strImie);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strNazwisko != pRs->m_szNazwisko)
		strcpy(pRs->m_szNazwisko, (LPCTSTR)m_strNazwisko);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strImieMalzonka != pRs->m_szImieMalzonka)
		strcpy(pRs->m_szImieMalzonka, (LPCTSTR)m_strImieMalzonka);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strAdres != pRs->m_szAdres)
		strcpy(pRs->m_szAdres, (LPCTSTR)m_strAdres);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strMiasto != pRs->m_szMiasto)
		strcpy(pRs->m_szMiasto, (LPCTSTR)m_strMiasto);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strStanlubProwincja != pRs->m_szStanlubProwincja)
		strcpy(pRs->m_szStanlubProwincja, (LPCTSTR)m_strStanlubProwincja);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strKodPocztowy != pRs->m_szKodPocztowy)
		strcpy(pRs->m_szKodPocztowy, (LPCTSTR)m_strKodPocztowy);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strKraj != pRs->m_szKraj)
		strcpy(pRs->m_szKraj, (LPCTSTR)m_strKraj);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strAdresEmail != pRs->m_szAdresEmail)
		strcpy(pRs->m_szAdresEmail, (LPCTSTR)m_strAdresEmail);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strTelefonDomowy != pRs->m_szTelefonDomowy)
		strcpy(pRs->m_szTelefonDomowy, (LPCTSTR)m_strTelefonDomowy);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strTelSluzbowy != pRs->m_szTelSluzbowy)
		strcpy(pRs->m_szTelSluzbowy, (LPCTSTR)m_strTelSluzbowy);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strWewnetrzny != pRs->m_szWewnetrzny)
		strcpy(pRs->m_szWewnetrzny, (LPCTSTR)m_strWewnetrzny);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strNumerFaksu != pRs->m_szNumerFaksu)
		strcpy(pRs->m_szNumerFaksu, (LPCTSTR)m_strNumerFaksu);
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (((DATE)m_oledtDataUR) != pRs->m_dtDataUR)
		pRs->m_dtDataUR = (DATE)m_oledtDataUR;
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_bKartaWysylki == TRUE)
		pRs->m_bKartaWysylki = VARIANT_TRUE;
	else
		pRs->m_bKartaWysylki = VARIANT_FALSE;
	// Czy pole zmienio si? Jeli tak, skopiuj jego warto z powrotem
	if (m_strUwagi != pRs->m_szUwagi)
		strcpy(pRs->m_szUwagi, (LPCTSTR)m_strUwagi);
}

void CDbAdoView::OnDataNew() 
{
	// TODO: Add your command handler code here
	// Update the current record
	UaktualnijDolaczoneDane();
	// Add a new record
	GetDocument()->DodajNowy();
	// Refresh the form with the new record's data
	OdswiezDolaczoneDane();
}

void CDbAdoView::OnDataDelete() 
{
	// TODO: Add your command handler code here
	// Update the current record
	UaktualnijDolaczoneDane();
	// Delete the current record
	GetDocument()->Usun();
	// Refresh the form with the new record's data
	OdswiezDolaczoneDane();
}
