// centeredView.cpp : implementation of the CCenteredView class
//

#include "stdafx.h"
#include "centered.h"

#include "centeredDoc.h"
#include "centeredView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCenteredView

IMPLEMENT_DYNCREATE(CCenteredView, CView)

BEGIN_MESSAGE_MAP(CCenteredView, CView)
	//{{AFX_MSG_MAP(CCenteredView)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCenteredView construction/destruction

CCenteredView::CCenteredView()
{
	// TODO: add construction code here

}

CCenteredView::~CCenteredView()
{
}

BOOL CCenteredView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CCenteredView drawing

void CCenteredView::OnDraw(CDC* pDC)
{
	CCenteredDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	CRect rect;

	GetWindowRect(&rect);
	int x = rect.Width()/2;
	int y = rect.Height()/2;

	CSize size = pDC->GetTextExtent(pDoc->StringData);

	x -= size.cx/2;
	y -= size.cy/2;

	pDC->TextOut(x, y, pDoc->StringData);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CCenteredView printing

BOOL CCenteredView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CCenteredView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CCenteredView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CCenteredView diagnostics

#ifdef _DEBUG
void CCenteredView::AssertValid() const
{
	CView::AssertValid();
}

void CCenteredView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CCenteredDoc* CCenteredView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCenteredDoc)));
	return (CCenteredDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCenteredView message handlers

void CCenteredView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CCenteredDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->StringData += nChar;
	Invalidate();

	CView::OnChar(nChar, nRepCnt, nFlags);
}
