// buggyView.cpp : implementation of the CBuggyView class
//

#include "stdafx.h"
#include "buggy.h"

#include "buggyDoc.h"
#include "buggyView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBuggyView

IMPLEMENT_DYNCREATE(CBuggyView, CView)

BEGIN_MESSAGE_MAP(CBuggyView, CView)
	//{{AFX_MSG_MAP(CBuggyView)
	ON_COMMAND(ID_CALCULATE_CALCULATEAVERAGE, OnCalculateCalculateaverage)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBuggyView construction/destruction

CBuggyView::CBuggyView()
{
	OutputString = "Wybierz polecenie Calculate Average z menu Calculate";
}

CBuggyView::~CBuggyView()
{
}

BOOL CBuggyView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CBuggyView drawing

void CBuggyView::OnDraw(CDC* pDC)
{
	CBuggyDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	
	pDC->TextOut(0, 0, OutputString);
}

/////////////////////////////////////////////////////////////////////////////
// CBuggyView printing

BOOL CBuggyView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CBuggyView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CBuggyView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CBuggyView diagnostics

#ifdef _DEBUG
void CBuggyView::AssertValid() const
{
	CView::AssertValid();
}

void CBuggyView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CBuggyDoc* CBuggyView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CBuggyDoc)));
	return (CBuggyDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBuggyView message handlers

void CBuggyView::OnCalculateCalculateaverage() 
{
	CBuggyDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	float Sum = 0;
	float Average;

	for(int loop = 0; loop < 5; loop++)
	{
		Sum += pDoc->data[loop];
	}

	Average = Sum / (float) 5.0;

	OutputString.Format("rednia z pierwszych piciu liczb cakowitych wynosi: %.3f", Average);

	Invalidate();
}
