﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Default_aspx : System.Web.UI.Page
{
    // Page events are wired up automatically to methods 
    // with the following names:
    // Page_Load, Page_AbortTransaction, Page_CommitTransaction,
    // Page_DataBinding, Page_Disposed, Page_Error, Page_Init, 
    // Page_Init Complete, Page_Load, Page_LoadComplete, Page_PreInit
    // Page_PreLoad, Page_PreRender, Page_PreRenderComplete, 
    // Page_SaveStateComplete, Page_Unload

	public override string StyleSheetTheme
	{
		get
		{
			if (Profile.IsAnonymous == false && Profile.Theme != null)
				return Profile.Theme;
			else
				return "Dark Blue";
		}
		set
		{
			Profile.Theme = value;
		}
	}

	public void Page_PreInit(object sender, EventArgs e)
	{
		if (Profile.IsAnonymous == false)
		{
			Page.Theme = Profile.Theme;
		}
	}
     
    protected void Page_Load(object sender, EventArgs e)
    {
		if (Profile.UserName != null && Profile.IsAnonymous == false)
		{
			this.lblFullName.Text = "Dane osobowe: " +
				Profile.firstName + " " + Profile.lastName;
			this.lblPhoneNumber.Text = "Telefon: " + Profile.phoneNumber;
			this.lblBirthDate.Text = "Urodzony: " + Profile.birthDate.ToShortDateString();
			this.pnlInfo.Visible = true;
		}
		else
		{
			this.pnlInfo.Visible = false;
		}

		if (Profile.CHOSENBOOKS != null)
		{
			this.lbBooks.DataSource = Profile.CHOSENBOOKS;
			this.lbBooks.DataBind();
			this.lbBooks.Visible = true;
		}
		else
		{
			this.lbBooks.Visible = false;
		}
	}  // koniec Page_Load
}  // koniec częściowej definicji klasy
