﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ManageRoles_aspx : System.Web.UI.Page
{
	string[] rolesArray;
	MembershipUserCollection users;
	string[] usersInRole;

	public void Page_Load()
	{
		Msg.Text = "";


		if (!IsPostBack)
		{
			rolesArray = Roles.GetAllRoles();
			RolesListBox.DataSource = rolesArray;
			RolesListBox.DataBind();

			// Wstawienie użytkowników do kontrolki ListBox.

			users = Membership.GetAllUsers();
			UsersListBox.DataSource = users;
			UsersListBox.DataBind();
		}

		if (RolesListBox.SelectedItem != null)
		{
			// Użytkownicy danej roli. Dowiązanie listy użytkowników do kontrolki GridView.

			usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value);
			UsersInRoleGrid.DataSource = usersInRole;
			UsersInRoleGrid.DataBind();
		}
	}

	// void AddUsersButton_Click(object sender, EventArgs e)

	public void AddUsers_OnClick(object sender, EventArgs args)
	{
		// Czy wybrano rolę?

		if (RolesListBox.SelectedItem == null)
		{
			Msg.Text = "Wybierz rolę.";
			return;
		}


		// Czy wybrano choćby jednego użytkownika?

		if (UsersListBox.SelectedItem == null)
		{
			Msg.Text = "Wybierz co najmniej jednego użytkownika.";
			return;
		}


		// Utworzenie listy użytkowników dodawanych do wskazanej roli.

		string[] newusers = new string[UsersListBox.GetSelectedIndices().Length];

		for (int i = 0; i < newusers.Length; i++)
		{
			newusers[i] = UsersListBox.Items[UsersListBox.GetSelectedIndices()[i]].Value;
		}


		// Dodanie użytkowników do wskazanej roli.

		try
		{
			Roles.AddUsersToRole(newusers, RolesListBox.SelectedItem.Value);

			// Ponowne dowiązanie użytkowników do ról w kontrolce GridView.

			usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value);
			UsersInRoleGrid.DataSource = usersInRole;
			UsersInRoleGrid.DataBind();
		}
		catch (HttpException e)
		{
			Msg.Text = e.Message;
		}
	}


	public void UsersInRoleGrid_RemoveFromRole(object sender, GridViewCommandEventArgs args)
	{
		// Wybranie użytkownika do pozbawienia roli.

		int index = Convert.ToInt32(args.CommandArgument);

		string username = ((DataBoundLiteralControl)UsersInRoleGrid.Rows[index].Cells[0].Controls[0]).Text;


		// Pozbawienie roli użytkownika.

		try
		{
			Roles.RemoveUserFromRole(username, RolesListBox.SelectedItem.Value);
		}
		catch (Exception e)
		{
			Msg.Text = "Podczas pozbawiania użytkownika roli nastąpił wyjątek typu "
				       + e.GetType().ToString() + ".";
		}


		// Aktualizacja przypisania użytkowników do ról w kontrolce GridView.

		usersInRole = Roles.GetUsersInRole(RolesListBox.SelectedItem.Value);
		UsersInRoleGrid.DataSource = usersInRole;
		UsersInRoleGrid.DataBind();
	}
	public void CreateRole_OnClick(object sender, EventArgs e)
	{
		pnlCreateRole.Visible = true;
	}

	/// <summary>
	/// Obsługuje klikanie przycisku Dodaj Add w panelu, aktywowanego kliknięciem
	/// przycisku Utwórz nową rolę
	/// </summary>
	public void btnAddRole_Click(object sender, EventArgs e)
	{
		// Czy nazwa roli zawiera jakikolwiek ciąg?
		if (txtNewRole.Text.Length > 0)
		{
			string newRole = txtNewRole.Text;

			// Jeśli rola jeszcze nie istnieje, trzeba ją dodać
			// do listy ról
			if (Roles.RoleExists(newRole) == false)
			{
				Roles.CreateRole(newRole);
				rolesArray = Roles.GetAllRoles();
				RolesListBox.DataSource = rolesArray;
				RolesListBox.DataBind();
			}
		}

		pnlCreateRole.Visible = false;
	}
}
