﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Threading;
using System.Text;
using System.Windows.Forms;

namespace BackgroundWorkerDemo
{
	public partial class Form1 : Form
	{
		public class TimerInfo
		{
			public string reminderMessage;
			public double numSeconds;
			public TimerInfo(String msg, double secs)
			{
				this.reminderMessage = msg;
				this.numSeconds = secs;
			}
		}

		public Form1()
		{
			InitializeComponent();
		}

		
		private void btnStart_Click(object sender, EventArgs e)
		{
			TimerInfo info = new TimerInfo(txtMessage.Text, Convert.ToDouble(this.txtSeconds.Text));

			txtMessage.Text = string.Empty;
			SetEnabled(true);
			backgroundWorker1.RunWorkerAsync(info);
		}

		private void SetEnabled(bool isRunning)
		{
			this.btnStart.Enabled = !isRunning;
			this.btnCancel.Enabled = isRunning;
			this.txtSeconds.Enabled = !isRunning;
			this.txtMessage.Enabled = !isRunning;
			if (isRunning)
			{
				this.progressBar1.Value = 0;
			}
		}

		private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
		{
			// This method will run on a thread other than the UI thread.
			// Be sure not to manipulate any Windows Forms controls created
			// on the UI thread from this method.
			BackgroundWorker worker = sender as BackgroundWorker;
			TimerInfo ti = (TimerInfo)e.Argument;

			DateTime startTime = DateTime.Now;
			do
			{
				if (worker.CancellationPending)
				{
					e.Cancel = true;
				}

				System.TimeSpan duration = DateTime.Now.Subtract(startTime);
				// konwersja sekund na wartośc typu int
				double totalSeconds = duration.TotalSeconds;
				double percent = totalSeconds / ti.numSeconds * 100.0;
				int progressPercent = (int)percent;
				progressPercent = progressPercent > 100 ? 100 : progressPercent;
				worker.ReportProgress(progressPercent);
				Thread.Sleep(20);
			}
			while (DateTime.Now < startTime.AddSeconds(ti.numSeconds));

			// e.Result będzie dostępne w
			// metodzie obsługi zdarzenia RunWorkerCompleted.
			e.Result = ti.reminderMessage;

		}

		// Aktualizacja wskaźnika postępu
		private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
		{
			this.progressBar1.Value = e.ProgressPercentage;
		}

		// Zakończenie odliczania
		private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
		{
			// Obsługa przypadku, kiedy zrzucono wyjątek
			if (e.Error != null)
			{
				MessageBox.Show(e.Error.Message);
			}
			else if (e.Cancelled)
			{
				txtMessage.Text = "ODWOŁANE.";
				SetEnabled(false);
			}
			else
			{
				// odliczanie zakończone
				txtMessage.Text = e.Result.ToString();
				//SetEnabled(false);
			}
		}

		// Odwołanie odliczania i zatrzymanie wątku
		private void btnCancel_Click(object sender, EventArgs e)
		{
			this.backgroundWorker1.CancelAsync();
			SetEnabled(false);
		}


	}
}