﻿using System;
using System.Collections.Generic;

namespace ImplementingGenericInterfaces
{
	public class Pilgrim : IComparable<Pilgrim>
	{
		private string name;
		public Pilgrim(string name)
		{
			this.name = name;
		}
		public override string ToString()
		{
			return this.name;
		}

		// implementacja interfejsu
		public int CompareTo(Pilgrim rhs)
		{
			return this.name.CompareTo(rhs.name);
		}
		public bool Equals(Pilgrim rhs)
		{
			return this.name == rhs.name;
		}
	}


	// węzeł musi być implementować interfejs IComparable dla węzłów Node typu T
	// węzeł może przechowywać jedynie te typy T, które implmentują IComparable
	// (warunek określany słowem kluczowym where).
	public class Node<T> : IComparable<Node<T>> where T:IComparable<T>
	{
		// pola składowe
		private T data;
		private Node<T> next = null;
		private Node<T> prev = null;

		// konstruktor
		public Node(T data)
		{
			this.data = data;
		}

		// właściwości
		public T Data { get { return this.data; } }

		public Node<T> Next
		{
			get { return this.next; }
		}

		public int CompareTo(Node<T> rhs)
		{
			// działa z racji ograniczenia (where T:IComparable<T>)
			return data.CompareTo(rhs.data); 
		}


		public bool Equals(Node<T> rhs)
		{
			return this.data.Equals(rhs.data);
		}




		// metody
		public Node<T> Add(Node<T> newNode)
		{
			if (this.CompareTo(newNode) > 0) // wstawienie przed węzeł bieżący
			{
				newNode.next = this;  // wskaźnik next ustawiany na węzeł bieżący

				// jeśli istnieje węzeł poprzedni, powinien od tego momentu
				// wskazywać polem next nowy węzeł
				if (this.prev != null)
				{
					this.prev.next = newNode;
					newNode.prev = this.prev;
				}

				// wskaźnik poprzednika węzła bieżącego ma wskazywać nowy węzeł
				this.prev = newNode;

				// zwrócenie referencji nowego węzła, jeśli stał się nowym czołem listy
				return newNode;
			}
			else			// wstawienie za węzeł bieżący
			{
				// jeśli bieżący nie jest ostatnim, całą operację przejmuje następny
				if (this.next != null)
				{
					this.next.Add(newNode);
				}

				// brak następnego węzła — nowy węzeł trzeba skojarzyć z polem next bieżącego;
				// a w polu prev nowego wstawić referencję do bieżącego
				else
				{
					this.next = newNode;
					newNode.prev = this;
				}

				return this;
			}
		}

		public override string ToString()
		{
			string output = data.ToString();

			if (next != null)
			{
				output += ", " + next.ToString();
			}

			return output;
		}
	}		// koniec klasy


	public class SortedLinkedList<T> where T : IComparable<T>
	{
		// member fields
		private Node<T>  headNode = null;


		// właściwości

		// indekser
		public T this[int index]
		{
			get
			{
				int ctr = 0;
				Node<T> node = headNode;

				while (node != null && ctr <= index)
				{
					if (ctr == index)
					{
						return node.Data;
					}
					else
					{
						node = node.Next;
					}

					++ctr;
				} // koniec while
				throw new ArgumentOutOfRangeException();
			}      // koniec get
		}          // koniec indeksera


		// konstruktor
		public SortedLinkedList()
		{
		}

		// metody
		public void Add(T data)
		{
			if (headNode == null)
			{
				headNode = new Node<T>(data);
			}
			else
			{
				headNode = headNode.Add(new Node<T>(data));
			}
		}
		public override string ToString()
		{
			if (this.headNode != null)
			{
				return this.headNode.ToString();
			}
			else
			{
				return string.Empty;
			}
		}
	}

	class Program
	{
		// punkt wejścia
		static void Main(string[] args)
		{
			SortedLinkedList<int> mySortedLinkedList = new SortedLinkedList<int>();
			Random rand = new Random();
			Console.Write("Wypełnianie: ");

			for (int i = 0; i < 10; i++)
			{
				int nextInt = rand.Next(10);
				Console.Write("{0}  ", nextInt);
				mySortedLinkedList.Add(nextInt);
			}

			SortedLinkedList<Pilgrim> pilgrims = new SortedLinkedList<Pilgrim>();
			pilgrims.Add(new Pilgrim("Rycerz"));
			pilgrims.Add(new Pilgrim("Młynarz"));
			pilgrims.Add(new Pilgrim("Szeryf"));
			pilgrims.Add(new Pilgrim("Kucharz"));
			pilgrims.Add(new Pilgrim("Adwokat"));

			Console.WriteLine("\nPobieranie kolekcji...");

			DisplayList<int>("Liczby", mySortedLinkedList);
			DisplayList<Pilgrim>("Pielgrzymi", pilgrims);
			//Console.WriteLine("Liczby: " + mySortedLinkedList);
			//Console.WriteLine("Pielgrzymi: " + pilgrims);

			Console.WriteLine("Czwarta liczba to " + mySortedLinkedList[3]);
			Pilgrim d = pilgrims[2];
			Console.WriteLine("Trzeci pielgrzym to " + d);

//			foreach (Pilgrim p in pilgrims)
//			{
//				Console.WriteLine("Zawód pielgrzyma to " + p.ToString());
//			}
		}	// end main

		private static void DisplayList<T>(string intro, SortedLinkedList<T> theList)
			where T : IComparable<T>
		{
			Console.WriteLine(intro + ": " + theList);
		}

	}	// koniec klasy
}		// koniec przestrzeni nazw

